#!/usr/bin/python
# vim: set fileencoding=utf-8

# Change source code to omit mutliple function calls.

import sys
import os
import glob
import re

Mod = "Pie'sAncientEurope"
ModOut = "PAE_Opt"

PyModPath = os.path.join("Mods", Mod, "Assets", "Python")
PyOutPath = os.path.join("Mods", ModOut, "Assets", "Python")
SourceFolders = [
		os.path.join("..", "Assets", "Python"),  # Vanilla
		os.path.join("..", "Warlords", "Assets", "Python"),  # WL
		os.path.join("Assets", "Python"),  # BTS
		PyModPath,  # Mod
]

try:
		from CvPythonExtensions import (CyGlobalContext, CyArtFileMgr, CyTranslator, CustomMapOptionTypes, TerrainTypes, PlotTypes, YieldTypes,
																		CommerceTypes, FontSymbols, CyGame, GameStateTypes, PopupStates, CameraLookAtTypes, CameraMovementSpeeds,
																		AdvisorTypes, FlavorTypes, EmphasizeTypes, GameOptionTypes, ZoomLevelTypes, DirectionTypes,
																		CardinalDirectionTypes, ColorTypes, PlotStyles, PlotLandscapeLayers, MultiplayerOptionTypes,
																		PlayerOptionTypes, PlayerColorTypes, AreaBorderLayers, InterfaceModeTypes, InterfaceMessageTypes,
																		MinimapModeTypes, SpecialOptionTypes, GraphicOptionTypes, EngineDirtyBits, InterfaceDirtyBits, CityTabTypes,
																		WidgetTypes, ButtonPopupTypes, ClimateTypes, SeaLevelTypes, WorldSizeTypes, ForceControlTypes, VictoryTypes,
																		FeatureTypes, BonusTypes, BonusClassTypes, OrderTypes, TaskTypes, TraitTypes, PlayerTypes, TeamTypes,
																		VoiceTargetTypes, ChatTargetTypes, FootstepAudioTags, FootstepAudioTypes, CitySizeTypes, ArtStyleTypes,
																		LeaderHeadTypes, CivilizationTypes, EraTypes, TurnTimerTypes, ImprovementTypes,
																		RouteTypes, RiverTypes, GoodyTypes, BuildTypes, HandicapTypes, GameSpeedTypes, DenialTypes, SeasonTypes,
																		MonthTypes, CalendarTypes, ConceptTypes, NewConceptTypes, HealthBarTypes, InfoBarTypes, VoteTypes,
																		PlayerVoteTypes, SymbolTypes, EventTriggerTypes, EventTypes,
																		BuildingTypes, SpecialBuildingTypes, ProjectTypes, UnitAITypes, BuildingClassTypes, ProcessTypes, DomainTypes,
																		UnitClassTypes, UnitTypes, SpecialUnitTypes, UnitCombatTypes, MissionTypes, InvisibleTypes, VoteSourceTypes,
																		ProbabilityTypes, ActivityTypes, AutomateTypes, EndTurnButtonStates, AreaAITypes, PromotionTypes, TechTypes,
																		HurryTypes, UpkeepTypes, WarPlanTypes, CivicTypes, ControlTypes, MissionAITypes, CommandTypes, AnimationTypes,
																		FogOfWarModeTypes, CivicOptionTypes, ReligionTypes, SpecialistTypes, CorporationTypes, CultureLevelTypes,
																		DiploEventTypes, EntityEventTypes, AnimationPathTypes, AnimationCategoryTypes, CursorTypes, TradeableItems,
																		SaveGameTypes, GameType, GameMode, InterfaceVisibility, DiplomacyPowerTypes, FeatTypes, AttitudeTypes,
																		LeaderheadAction, NetContactTypes, ContactTypes, MemoryTypes, DiploCommentTypes, PopupControlLayout,
																		GameMessageTypes, ActionSubTypes, CivilopediaPageTypes, AudioTag, ReplayMessageTypes, TabGroupTypes,
																		EventContextTypes, TableStyles, ButtonStyles, PanelStyles, FontTypes, LoadType, EventType,
																		WorldBuilderPopupTypes, GenericButtonSizes, JustificationTypes, ToolTipAlignTypes, ActivationTypes,
																		HitTestTypes, GraphicLevelTypes, MouseFlags, NotifyCode, AdvancedStartActionTypes, EspionageMissionTypes)
except:
		PyOutPath = os.path.join(os.path.sep, "dev", "shm", "Python")
		import os.path
		sys.path.append(os.path.expandvars("$HOME/python/PAE"))
		sys.path.append(os.path.join(PyModPath, "..", "..",
																 "Extras", "Pylint_for_Civ4", "Civ4PythonApi"))
		from CvPythonExtensions import (CyGlobalContext, CyArtFileMgr, CyTranslator, CustomMapOptionTypes, TerrainTypes, PlotTypes, YieldTypes,
																		CommerceTypes, FontSymbols, CyGame, GameStateTypes, PopupStates, CameraLookAtTypes, CameraMovementSpeeds,
																		AdvisorTypes, FlavorTypes, EmphasizeTypes, GameOptionTypes, ZoomLevelTypes, DirectionTypes,
																		CardinalDirectionTypes, ColorTypes, PlotStyles, PlotLandscapeLayers, MultiplayerOptionTypes,
																		PlayerOptionTypes, PlayerColorTypes, AreaBorderLayers, InterfaceModeTypes, InterfaceMessageTypes,
																		MinimapModeTypes, SpecialOptionTypes, GraphicOptionTypes, EngineDirtyBits, InterfaceDirtyBits, CityTabTypes,
																		WidgetTypes, ButtonPopupTypes, ClimateTypes, SeaLevelTypes, WorldSizeTypes, ForceControlTypes, VictoryTypes,
																		FeatureTypes, BonusTypes, BonusClassTypes, OrderTypes, TaskTypes, TraitTypes, PlayerTypes, TeamTypes,
																		VoiceTargetTypes, ChatTargetTypes, FootstepAudioTags, FootstepAudioTypes, CitySizeTypes, ArtStyleTypes,
																		LeaderHeadTypes, CivilizationTypes, EraTypes, TurnTimerTypes, ImprovementTypes,
																		RouteTypes, RiverTypes, GoodyTypes, BuildTypes, HandicapTypes, GameSpeedTypes, DenialTypes, SeasonTypes,
																		MonthTypes, CalendarTypes, ConceptTypes, NewConceptTypes, HealthBarTypes, InfoBarTypes, VoteTypes,
																		PlayerVoteTypes, SymbolTypes, EventTriggerTypes, EventTypes,
																		BuildingTypes, SpecialBuildingTypes, ProjectTypes, UnitAITypes, BuildingClassTypes, ProcessTypes, DomainTypes,
																		UnitClassTypes, UnitTypes, SpecialUnitTypes, UnitCombatTypes, MissionTypes, InvisibleTypes, VoteSourceTypes,
																		ProbabilityTypes, ActivityTypes, AutomateTypes, EndTurnButtonStates, AreaAITypes, PromotionTypes, TechTypes,
																		HurryTypes, UpkeepTypes, WarPlanTypes, CivicTypes, ControlTypes, MissionAITypes, CommandTypes, AnimationTypes,
																		FogOfWarModeTypes, CivicOptionTypes, ReligionTypes, SpecialistTypes, CorporationTypes, CultureLevelTypes,
																		DiploEventTypes, EntityEventTypes, AnimationPathTypes, AnimationCategoryTypes, CursorTypes, TradeableItems,
																		SaveGameTypes, GameType, GameMode, InterfaceVisibility, DiplomacyPowerTypes, FeatTypes, AttitudeTypes,
																		LeaderheadAction, NetContactTypes, ContactTypes, MemoryTypes, DiploCommentTypes, PopupControlLayout,
																		GameMessageTypes, ActionSubTypes, CivilopediaPageTypes, AudioTag, ReplayMessageTypes, TabGroupTypes,
																		EventContextTypes, TableStyles, ButtonStyles, PanelStyles, FontTypes, LoadType, EventType,
																		WorldBuilderPopupTypes, GenericButtonSizes, JustificationTypes, ToolTipAlignTypes, ActivationTypes,
																		HitTestTypes, GraphicLevelTypes, MouseFlags, NotifyCode, AdvancedStartActionTypes, EspionageMissionTypes)

gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()


def undefined_warner(handler, *lArgs):
		s = str(handler(*lArgs))
		if(s) == "-1":
				print("Warning: %s(%s) returns %s" % (
						handler.__name__, ", ".join(lArgs), s))

		return s


def empty_str(_):
		return ""


def nestedINT(s):
		return "(" + str(gc.getDefineINT(s)) + ")"


def nestedFLOAT(s):
		return "(" + str(gc.getDefineFLOAT(s)) + ")"


def getInterfaceArtInfo(sArt):
		return "'" + ArtFileMgr.getInterfaceArtInfo(sArt).getPath() + "'"


def getSymbolID_for_enum_str(s):
		if s in FontSymbols.__dict__:
				return str(CyGame().getSymbolID(FontSymbols.__dict__[s]))

		print("Warning: Can not eval symbol id.")
		return -1


Replace_descriptors = {
		__name__: (
				r'^.*'+__name__+'.*$', 0, '%s', empty_str
		),
		"getInfoTypeForString": (
				r'(self\.)?gc.getInfoTypeForString\(\s*[\'"]([^\'"]*)[\'"]\s*\)',
				2, '%s',  # Resolving of args for Function handler
				gc.getInfoTypeForString,  # Function handler
		),
		"findInfoTypeNum": (
				r'CvUtil.findInfoTypeNum\([^,]*,[^,]*,\s*[\'"]([^\'"]*)[\'"]\s*\)',
				1, '%s',  # Resolving of args for Function handler
				gc.getInfoTypeForString,  # Function handler
		),
		"getInterfaceArtInfo": (
				r'(ArtFileMgr|CyArtFileMgr\(\)).getInterfaceArtInfo\(\s*[\'"]([^\'"]*)[\'"]\s*\).getPath\(\)',
				2, '%s',
				getInterfaceArtInfo,
		),
		"getDefineINT": (
				r'gc.getDefineINT\(\s*[\'"]([^\'"]*)[\'"]\s*\)',
				1, '%s',  # Resolving of args for Function handler
				nestedINT,  # Function handler
		),
		"getDefineFLOAT": (
				r'gc.getDefineFLOAT\(\s*[\'"]([^\'"]*)[\'"]\s*\)',
				1, '%s',  # Resolving of args for Function handler
				nestedFLOAT  # Function handler
		),
		"getSymbolID": (
				r'CyGame\(\).getSymbolID\(\s*([0-9]*)\s*\)',
				1, '%s',  # Resolving of args for Function handler
				CyGame().getSymbolID  # Function handler
		),
		"getSymbolI": (  # other keyname...
				r'CyGame\(\).getSymbolID\(\s*FontSymbols\.([A-z_]*)\s*\)',
				1, '%s',  # Resolving of args for Function handler
				getSymbolID_for_enum_str  # Function handler
		),
}

Constant_substitutions = {
		"max_players": ["gc.getMAX_PLAYERS()", gc.getMAX_PLAYERS()],
		"max_teams": ["gc.getMAX_TEAMS()", gc.getMAX_TEAMS()],
		"barb_player": ["gc.getBARBARIAN_PLAYER()", gc.getBARBARIAN_PLAYER()],
		"barb_team": ["gc.getBARBARIAN_TEAM()", gc.getBARBARIAN_TEAM()],
}

"""
Problem: Type substitution runs into the issue that many function assumes
that the arguments are of type Boost.Python.enum. This function can not
be called with int's....
"""
Type_varname_splitter = list(" :),+-%\t")
Type_substitutions = {
		"GameStateTypes.GAMESTATE_ON": [GameStateTypes.GAMESTATE_ON],
		"GameStateTypes.GAMESTATE_OVER": [GameStateTypes.GAMESTATE_OVER],
		"GameStateTypes.GAMESTATE_EXTENDED": [GameStateTypes.GAMESTATE_EXTENDED],
		"PopupStates.POPUPSTATE_IMMEDIATE": [PopupStates.POPUPSTATE_IMMEDIATE],
		"PopupStates.POPUPSTATE_QUEUED": [PopupStates.POPUPSTATE_QUEUED],
		"PopupStates.POPUPSTATE_MINIMIZED": [PopupStates.POPUPSTATE_MINIMIZED],
		"CameraLookAtTypes.CAMERALOOKAT_NORMAL": [CameraLookAtTypes.CAMERALOOKAT_NORMAL],
		"CameraLookAtTypes.CAMERALOOKAT_CITY_ZOOM_IN": [CameraLookAtTypes.CAMERALOOKAT_CITY_ZOOM_IN],
		"CameraLookAtTypes.CAMERALOOKAT_BATTLE": [CameraLookAtTypes.CAMERALOOKAT_BATTLE],
		"CameraLookAtTypes.CAMERALOOKAT_BATTLE_ZOOM_IN": [CameraLookAtTypes.CAMERALOOKAT_BATTLE_ZOOM_IN],
		"CameraLookAtTypes.CAMERALOOKAT_IMMEDIATE": [CameraLookAtTypes.CAMERALOOKAT_IMMEDIATE],
		"CameraMovementSpeeds.CAMERAMOVEMENTSPEED_NORMAL": [CameraMovementSpeeds.CAMERAMOVEMENTSPEED_NORMAL],
		"CameraMovementSpeeds.CAMERAMOVEMENTSPEED_SLOW": [CameraMovementSpeeds.CAMERAMOVEMENTSPEED_SLOW],
		"CameraMovementSpeeds.CAMERAMOVEMENTSPEED_FAST": [CameraMovementSpeeds.CAMERAMOVEMENTSPEED_FAST],
		"ZoomLevelTypes.ZOOM_UNKNOWN": [ZoomLevelTypes.ZOOM_UNKNOWN],
		"ZoomLevelTypes.ZOOM_GLOBEVIEW": [ZoomLevelTypes.ZOOM_GLOBEVIEW],
		"ZoomLevelTypes.ZOOM_NORMAL": [ZoomLevelTypes.ZOOM_NORMAL],
		"ZoomLevelTypes.ZOOM_DETAIL": [ZoomLevelTypes.ZOOM_DETAIL],
		"DirectionTypes.NO_DIRECTION": [DirectionTypes.NO_DIRECTION],
		"DirectionTypes.DIRECTION_NORTH": [DirectionTypes.DIRECTION_NORTH],
		"DirectionTypes.DIRECTION_NORTHEAST": [DirectionTypes.DIRECTION_NORTHEAST],
		"DirectionTypes.DIRECTION_EAST": [DirectionTypes.DIRECTION_EAST],
		"DirectionTypes.DIRECTION_SOUTHEAST": [DirectionTypes.DIRECTION_SOUTHEAST],
		"DirectionTypes.DIRECTION_SOUTH": [DirectionTypes.DIRECTION_SOUTH],
		"DirectionTypes.DIRECTION_SOUTHWEST": [DirectionTypes.DIRECTION_SOUTHWEST],
		"DirectionTypes.DIRECTION_WEST": [DirectionTypes.DIRECTION_WEST],
		"DirectionTypes.DIRECTION_NORTHWEST": [DirectionTypes.DIRECTION_NORTHWEST],
		"DirectionTypes.NUM_DIRECTION_TYPES": [DirectionTypes.NUM_DIRECTION_TYPES],
		"CardinalDirectionTypes.NO_CARDINALDIRECTION": [CardinalDirectionTypes.NO_CARDINALDIRECTION],
		"CardinalDirectionTypes.CARDINALDIRECTION_NORTH": [CardinalDirectionTypes.CARDINALDIRECTION_NORTH],
		"CardinalDirectionTypes.CARDINALDIRECTION_EAST": [CardinalDirectionTypes.CARDINALDIRECTION_EAST],
		"CardinalDirectionTypes.CARDINALDIRECTION_SOUTH": [CardinalDirectionTypes.CARDINALDIRECTION_SOUTH],
		"CardinalDirectionTypes.CARDINALDIRECTION_WEST": [CardinalDirectionTypes.CARDINALDIRECTION_WEST],
		"CardinalDirectionTypes.NUM_CARDINALDIRECTION_TYPES": [CardinalDirectionTypes.NUM_CARDINALDIRECTION_TYPES],
		"ColorTypes.NO_COLOR": [ColorTypes.NO_COLOR],
		"PlayerColorTypes.NO_PLAYERCOLOR": [PlayerColorTypes.NO_PLAYERCOLOR],
		"PlotStyles.PLOT_STYLE_NONE": [PlotStyles.PLOT_STYLE_NONE],
		"PlotStyles.PLOT_STYLE_NUMPAD_1": [PlotStyles.PLOT_STYLE_NUMPAD_1],
		"PlotStyles.PLOT_STYLE_NUMPAD_2": [PlotStyles.PLOT_STYLE_NUMPAD_2],
		"PlotStyles.PLOT_STYLE_NUMPAD_3": [PlotStyles.PLOT_STYLE_NUMPAD_3],
		"PlotStyles.PLOT_STYLE_NUMPAD_4": [PlotStyles.PLOT_STYLE_NUMPAD_4],
		"PlotStyles.PLOT_STYLE_NUMPAD_6": [PlotStyles.PLOT_STYLE_NUMPAD_6],
		"PlotStyles.PLOT_STYLE_NUMPAD_7": [PlotStyles.PLOT_STYLE_NUMPAD_7],
		"PlotStyles.PLOT_STYLE_NUMPAD_8": [PlotStyles.PLOT_STYLE_NUMPAD_8],
		"PlotStyles.PLOT_STYLE_NUMPAD_9": [PlotStyles.PLOT_STYLE_NUMPAD_9],
		"PlotStyles.PLOT_STYLE_NUMPAD_1_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_1_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_2_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_2_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_3_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_3_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_4_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_4_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_6_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_6_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_7_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_7_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_8_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_8_ANGLED],
		"PlotStyles.PLOT_STYLE_NUMPAD_9_ANGLED": [PlotStyles.PLOT_STYLE_NUMPAD_9_ANGLED],
		"PlotStyles.PLOT_STYLE_BOX_FILL": [PlotStyles.PLOT_STYLE_BOX_FILL],
		"PlotStyles.PLOT_STYLE_BOX_OUTLINE": [PlotStyles.PLOT_STYLE_BOX_OUTLINE],
		"PlotStyles.PLOT_STYLE_RIVER_SOUTH": [PlotStyles.PLOT_STYLE_RIVER_SOUTH],
		"PlotStyles.PLOT_STYLE_RIVER_EAST": [PlotStyles.PLOT_STYLE_RIVER_EAST],
		"PlotStyles.PLOT_STYLE_SIDE_ARROWS": [PlotStyles.PLOT_STYLE_SIDE_ARROWS],
		"PlotStyles.PLOT_STYLE_CIRCLE": [PlotStyles.PLOT_STYLE_CIRCLE],
		"PlotStyles.PLOT_STYLE_TARGET": [PlotStyles.PLOT_STYLE_TARGET],
		"PlotStyles.PLOT_STYLE_DOT_TARGET": [PlotStyles.PLOT_STYLE_DOT_TARGET],
		"PlotStyles.PLOT_STYLE_WAVES": [PlotStyles.PLOT_STYLE_WAVES],
		"PlotStyles.PLOT_STYLE_DOTS": [PlotStyles.PLOT_STYLE_DOTS],
		"PlotStyles.PLOT_STYLE_CIRCLES": [PlotStyles.PLOT_STYLE_CIRCLES],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_ALL": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_ALL],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_BASE": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_BASE],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_WORLD_BUILDER": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_WORLD_BUILDER],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_NUMPAD_HELP": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_NUMPAD_HELP],
		"PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS": [PlotLandscapeLayers.PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS],
		"AreaBorderLayers.AREA_BORDER_LAYER_REVEALED_PLOTS": [AreaBorderLayers.AREA_BORDER_LAYER_REVEALED_PLOTS],
		"AreaBorderLayers.AREA_BORDER_LAYER_WORLD_BUILDER": [AreaBorderLayers.AREA_BORDER_LAYER_WORLD_BUILDER],
		"AreaBorderLayers.AREA_BORDER_LAYER_FOUNDING_BORDER": [AreaBorderLayers.AREA_BORDER_LAYER_FOUNDING_BORDER],
		"AreaBorderLayers.AREA_BORDER_LAYER_CITY_RADIUS": [AreaBorderLayers.AREA_BORDER_LAYER_CITY_RADIUS],
		"AreaBorderLayers.AREA_BORDER_LAYER_RANGED": [AreaBorderLayers.AREA_BORDER_LAYER_RANGED],
		"AreaBorderLayers.AREA_BORDER_LAYER_HIGHLIGHT_PLOT": [AreaBorderLayers.AREA_BORDER_LAYER_HIGHLIGHT_PLOT],
		"AreaBorderLayers.AREA_BORDER_LAYER_BLOCKADING": [AreaBorderLayers.AREA_BORDER_LAYER_BLOCKADING],
		"AreaBorderLayers.AREA_BORDER_LAYER_BLOCKADED": [AreaBorderLayers.AREA_BORDER_LAYER_BLOCKADED],
		"AreaBorderLayers.NUM_AREA_BORDER_LAYERS": [AreaBorderLayers.NUM_AREA_BORDER_LAYERS],
		"InterfaceModeTypes.NO_INTERFACEMODE": [InterfaceModeTypes.NO_INTERFACEMODE],
		"InterfaceModeTypes.INTERFACEMODE_SELECTION": [InterfaceModeTypes.INTERFACEMODE_SELECTION],
		"InterfaceModeTypes.INTERFACEMODE_PING": [InterfaceModeTypes.INTERFACEMODE_PING],
		"InterfaceModeTypes.INTERFACEMODE_SIGN": [InterfaceModeTypes.INTERFACEMODE_SIGN],
		"InterfaceModeTypes.INTERFACEMODE_GRIP": [InterfaceModeTypes.INTERFACEMODE_GRIP],
		"InterfaceModeTypes.INTERFACEMODE_GLOBELAYER_INPUT": [InterfaceModeTypes.INTERFACEMODE_GLOBELAYER_INPUT],
		"InterfaceModeTypes.INTERFACEMODE_GO_TO": [InterfaceModeTypes.INTERFACEMODE_GO_TO],
		"InterfaceModeTypes.INTERFACEMODE_GO_TO_TYPE": [InterfaceModeTypes.INTERFACEMODE_GO_TO_TYPE],
		"InterfaceModeTypes.INTERFACEMODE_GO_TO_ALL": [InterfaceModeTypes.INTERFACEMODE_GO_TO_ALL],
		"InterfaceModeTypes.INTERFACEMODE_ROUTE_TO": [InterfaceModeTypes.INTERFACEMODE_ROUTE_TO],
		"InterfaceModeTypes.INTERFACEMODE_AIRLIFT": [InterfaceModeTypes.INTERFACEMODE_AIRLIFT],
		"InterfaceModeTypes.INTERFACEMODE_NUKE": [InterfaceModeTypes.INTERFACEMODE_NUKE],
		"InterfaceModeTypes.INTERFACEMODE_RECON": [InterfaceModeTypes.INTERFACEMODE_RECON],
		"InterfaceModeTypes.INTERFACEMODE_PARADROP": [InterfaceModeTypes.INTERFACEMODE_PARADROP],
		"InterfaceModeTypes.INTERFACEMODE_AIRBOMB": [InterfaceModeTypes.INTERFACEMODE_AIRBOMB],
		"InterfaceModeTypes.INTERFACEMODE_RANGE_ATTACK": [InterfaceModeTypes.INTERFACEMODE_RANGE_ATTACK],
		"InterfaceModeTypes.INTERFACEMODE_AIRSTRIKE": [InterfaceModeTypes.INTERFACEMODE_AIRSTRIKE],
		"InterfaceModeTypes.INTERFACEMODE_REBASE": [InterfaceModeTypes.INTERFACEMODE_REBASE],
		"InterfaceModeTypes.INTERFACEMODE_PYTHON_PICK_PLOT": [InterfaceModeTypes.INTERFACEMODE_PYTHON_PICK_PLOT],
		"InterfaceModeTypes.INTERFACEMODE_SAVE_PLOT_NIFS": [InterfaceModeTypes.INTERFACEMODE_SAVE_PLOT_NIFS],
		"InterfaceModeTypes.NUM_INTERFACEMODE_TYPES": [InterfaceModeTypes.NUM_INTERFACEMODE_TYPES],
		"InterfaceMessageTypes.NO_MESSAGE_TYPE": [InterfaceMessageTypes.NO_MESSAGE_TYPE],
		"InterfaceMessageTypes.MESSAGE_TYPE_INFO": [InterfaceMessageTypes.MESSAGE_TYPE_INFO],
		"InterfaceMessageTypes.MESSAGE_TYPE_DISPLAY_ONLY": [InterfaceMessageTypes.MESSAGE_TYPE_DISPLAY_ONLY],
		"InterfaceMessageTypes.MESSAGE_TYPE_MAJOR_EVENT": [InterfaceMessageTypes.MESSAGE_TYPE_MAJOR_EVENT],
		"InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT": [InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT],
		"InterfaceMessageTypes.MESSAGE_TYPE_CHAT": [InterfaceMessageTypes.MESSAGE_TYPE_CHAT],
		"InterfaceMessageTypes.MESSAGE_TYPE_COMBAT_MESSAGE": [InterfaceMessageTypes.MESSAGE_TYPE_COMBAT_MESSAGE],
		"InterfaceMessageTypes.MESSAGE_TYPE_QUEST": [InterfaceMessageTypes.MESSAGE_TYPE_QUEST],
		"InterfaceMessageTypes.NUM_INTERFACE_MESSAGE_TYPES": [InterfaceMessageTypes.NUM_INTERFACE_MESSAGE_TYPES],
		"MinimapModeTypes.NO_MINIMAPMODE": [MinimapModeTypes.NO_MINIMAPMODE],
		"MinimapModeTypes.MINIMAPMODE_TERRITORY": [MinimapModeTypes.MINIMAPMODE_TERRITORY],
		"MinimapModeTypes.MINIMAPMODE_TERRAIN": [MinimapModeTypes.MINIMAPMODE_TERRAIN],
		"MinimapModeTypes.MINIMAPMODE_REPLAY": [MinimapModeTypes.MINIMAPMODE_REPLAY],
		"MinimapModeTypes.MINIMAPMODE_MILITARY": [MinimapModeTypes.MINIMAPMODE_MILITARY],
		"MinimapModeTypes.NUM_MINIMAPMODE_TYPES": [MinimapModeTypes.NUM_MINIMAPMODE_TYPES],
		"EngineDirtyBits.GlobeTexture_DIRTY_BIT": [EngineDirtyBits.GlobeTexture_DIRTY_BIT],
		"EngineDirtyBits.MinimapTexture_DIRTY_BIT": [EngineDirtyBits.MinimapTexture_DIRTY_BIT],
		"EngineDirtyBits.CultureBorders_DIRTY_BIT": [EngineDirtyBits.CultureBorders_DIRTY_BIT],
		"EngineDirtyBits.NUM_ENGINE_DIRTY_BITS": [EngineDirtyBits.NUM_ENGINE_DIRTY_BITS],
		"InterfaceDirtyBits.SelectionCamera_DIRTY_BIT": [InterfaceDirtyBits.SelectionCamera_DIRTY_BIT],
		"InterfaceDirtyBits.Fog_DIRTY_BIT": [InterfaceDirtyBits.Fog_DIRTY_BIT],
		"InterfaceDirtyBits.GlobeLayer_DIRTY_BIT": [InterfaceDirtyBits.GlobeLayer_DIRTY_BIT],
		"InterfaceDirtyBits.GlobeInfo_DIRTY_BIT": [InterfaceDirtyBits.GlobeInfo_DIRTY_BIT],
		"InterfaceDirtyBits.Waypoints_DIRTY_BIT": [InterfaceDirtyBits.Waypoints_DIRTY_BIT],
		"InterfaceDirtyBits.PercentButtons_DIRTY_BIT": [InterfaceDirtyBits.PercentButtons_DIRTY_BIT],
		"InterfaceDirtyBits.MiscButtons_DIRTY_BIT": [InterfaceDirtyBits.MiscButtons_DIRTY_BIT],
		"InterfaceDirtyBits.PlotListButtons_DIRTY_BIT": [InterfaceDirtyBits.PlotListButtons_DIRTY_BIT],
		"InterfaceDirtyBits.SelectionButtons_DIRTY_BIT": [InterfaceDirtyBits.SelectionButtons_DIRTY_BIT],
		"InterfaceDirtyBits.CitizenButtons_DIRTY_BIT": [InterfaceDirtyBits.CitizenButtons_DIRTY_BIT],
		"InterfaceDirtyBits.ResearchButtons_DIRTY_BIT": [InterfaceDirtyBits.ResearchButtons_DIRTY_BIT],
		"InterfaceDirtyBits.Event_DIRTY_BIT": [InterfaceDirtyBits.Event_DIRTY_BIT],
		"InterfaceDirtyBits.Center_DIRTY_BIT": [InterfaceDirtyBits.Center_DIRTY_BIT],
		"InterfaceDirtyBits.GameData_DIRTY_BIT": [InterfaceDirtyBits.GameData_DIRTY_BIT],
		"InterfaceDirtyBits.Score_DIRTY_BIT": [InterfaceDirtyBits.Score_DIRTY_BIT],
		"InterfaceDirtyBits.TurnTimer_DIRTY_BIT": [InterfaceDirtyBits.TurnTimer_DIRTY_BIT],
		"InterfaceDirtyBits.Help_DIRTY_BIT": [InterfaceDirtyBits.Help_DIRTY_BIT],
		"InterfaceDirtyBits.MinimapSection_DIRTY_BIT": [InterfaceDirtyBits.MinimapSection_DIRTY_BIT],
		"InterfaceDirtyBits.SelectionSound_DIRTY_BIT": [InterfaceDirtyBits.SelectionSound_DIRTY_BIT],
		"InterfaceDirtyBits.Cursor_DIRTY_BIT": [InterfaceDirtyBits.Cursor_DIRTY_BIT],
		"InterfaceDirtyBits.CityInfo_DIRTY_BIT": [InterfaceDirtyBits.CityInfo_DIRTY_BIT],
		"InterfaceDirtyBits.UnitInfo_DIRTY_BIT": [InterfaceDirtyBits.UnitInfo_DIRTY_BIT],
		"InterfaceDirtyBits.Popup_DIRTY_BIT": [InterfaceDirtyBits.Popup_DIRTY_BIT],
		"InterfaceDirtyBits.CityScreen_DIRTY_BIT": [InterfaceDirtyBits.CityScreen_DIRTY_BIT],
		"InterfaceDirtyBits.InfoPane_DIRTY_BIT": [InterfaceDirtyBits.InfoPane_DIRTY_BIT],
		"InterfaceDirtyBits.Flag_DIRTY_BIT": [InterfaceDirtyBits.Flag_DIRTY_BIT],
		"InterfaceDirtyBits.HighlightPlot_DIRTY_BIT": [InterfaceDirtyBits.HighlightPlot_DIRTY_BIT],
		"InterfaceDirtyBits.ColoredPlots_DIRTY_BIT": [InterfaceDirtyBits.ColoredPlots_DIRTY_BIT],
		"InterfaceDirtyBits.BlockadedPlots_DIRTY_BIT": [InterfaceDirtyBits.BlockadedPlots_DIRTY_BIT],
		"InterfaceDirtyBits.Financial_Screen_DIRTY_BIT": [InterfaceDirtyBits.Financial_Screen_DIRTY_BIT],
		"InterfaceDirtyBits.Foreign_Screen_DIRTY_BIT": [InterfaceDirtyBits.Foreign_Screen_DIRTY_BIT],
		"InterfaceDirtyBits.Soundtrack_DIRTY_BIT": [InterfaceDirtyBits.Soundtrack_DIRTY_BIT],
		"InterfaceDirtyBits.Domestic_Advisor_DIRTY_BIT": [InterfaceDirtyBits.Domestic_Advisor_DIRTY_BIT],
		"InterfaceDirtyBits.Espionage_Advisor_DIRTY_BIT": [InterfaceDirtyBits.Espionage_Advisor_DIRTY_BIT],
		"InterfaceDirtyBits.Advanced_Start_DIRTY_BIT": [InterfaceDirtyBits.Advanced_Start_DIRTY_BIT],
		"InterfaceDirtyBits.NUM_INTERFACE_DIRTY_BITS": [InterfaceDirtyBits.NUM_INTERFACE_DIRTY_BITS],
		"CityTabTypes.CITYTAB_UNITS": [CityTabTypes.CITYTAB_UNITS],
		"CityTabTypes.CITYTAB_BUILDINGS": [CityTabTypes.CITYTAB_BUILDINGS],
		"CityTabTypes.CITYTAB_WONDERS": [CityTabTypes.CITYTAB_WONDERS],
		"CityTabTypes.NUM_CITYTAB_TYPES": [CityTabTypes.NUM_CITYTAB_TYPES],
		"WidgetTypes.WIDGET_PLOT_LIST": [WidgetTypes.WIDGET_PLOT_LIST],
		"WidgetTypes.WIDGET_PLOT_LIST_SHIFT": [WidgetTypes.WIDGET_PLOT_LIST_SHIFT],
		"WidgetTypes.WIDGET_CITY_SCROLL": [WidgetTypes.WIDGET_CITY_SCROLL],
		"WidgetTypes.WIDGET_LIBERATE_CITY": [WidgetTypes.WIDGET_LIBERATE_CITY],
		"WidgetTypes.WIDGET_CITY_NAME": [WidgetTypes.WIDGET_CITY_NAME],
		"WidgetTypes.WIDGET_UNIT_NAME": [WidgetTypes.WIDGET_UNIT_NAME],
		"WidgetTypes.WIDGET_CREATE_GROUP": [WidgetTypes.WIDGET_CREATE_GROUP],
		"WidgetTypes.WIDGET_DELETE_GROUP": [WidgetTypes.WIDGET_DELETE_GROUP],
		"WidgetTypes.WIDGET_TRAIN": [WidgetTypes.WIDGET_TRAIN],
		"WidgetTypes.WIDGET_CONSTRUCT": [WidgetTypes.WIDGET_CONSTRUCT],
		"WidgetTypes.WIDGET_CREATE": [WidgetTypes.WIDGET_CREATE],
		"WidgetTypes.WIDGET_MAINTAIN": [WidgetTypes.WIDGET_MAINTAIN],
		"WidgetTypes.WIDGET_HURRY": [WidgetTypes.WIDGET_HURRY],
		"WidgetTypes.WIDGET_MENU_ICON": [WidgetTypes.WIDGET_MENU_ICON],
		"WidgetTypes.WIDGET_CONSCRIPT": [WidgetTypes.WIDGET_CONSCRIPT],
		"WidgetTypes.WIDGET_ACTION": [WidgetTypes.WIDGET_ACTION],
		"WidgetTypes.WIDGET_DISABLED_CITIZEN": [WidgetTypes.WIDGET_DISABLED_CITIZEN],
		"WidgetTypes.WIDGET_CITIZEN": [WidgetTypes.WIDGET_CITIZEN],
		"WidgetTypes.WIDGET_FREE_CITIZEN": [WidgetTypes.WIDGET_FREE_CITIZEN],
		"WidgetTypes.WIDGET_ANGRY_CITIZEN": [WidgetTypes.WIDGET_ANGRY_CITIZEN],
		"WidgetTypes.WIDGET_CHANGE_SPECIALIST": [WidgetTypes.WIDGET_CHANGE_SPECIALIST],
		"WidgetTypes.WIDGET_RESEARCH": [WidgetTypes.WIDGET_RESEARCH],
		"WidgetTypes.WIDGET_TECH_TREE": [WidgetTypes.WIDGET_TECH_TREE],
		"WidgetTypes.WIDGET_CHANGE_PERCENT": [WidgetTypes.WIDGET_CHANGE_PERCENT],
		"WidgetTypes.WIDGET_CITY_TAB": [WidgetTypes.WIDGET_CITY_TAB],
		"WidgetTypes.WIDGET_CONTACT_CIV": [WidgetTypes.WIDGET_CONTACT_CIV],
		"WidgetTypes.WIDGET_SCORE_BREAKDOWN": [WidgetTypes.WIDGET_SCORE_BREAKDOWN],
		"WidgetTypes.WIDGET_ZOOM_CITY": [WidgetTypes.WIDGET_ZOOM_CITY],
		"WidgetTypes.WIDGET_END_TURN": [WidgetTypes.WIDGET_END_TURN],
		"WidgetTypes.WIDGET_LAUNCH_VICTORY": [WidgetTypes.WIDGET_LAUNCH_VICTORY],
		"WidgetTypes.WIDGET_CONVERT": [WidgetTypes.WIDGET_CONVERT],
		"WidgetTypes.WIDGET_WB_SAVE_BUTTON": [WidgetTypes.WIDGET_WB_SAVE_BUTTON],
		"WidgetTypes.WIDGET_WB_LOAD_BUTTON": [WidgetTypes.WIDGET_WB_LOAD_BUTTON],
		"WidgetTypes.WIDGET_WB_ALL_PLOTS_BUTTON": [WidgetTypes.WIDGET_WB_ALL_PLOTS_BUTTON],
		"WidgetTypes.WIDGET_WB_LANDMARK_BUTTON": [WidgetTypes.WIDGET_WB_LANDMARK_BUTTON],
		"WidgetTypes.WIDGET_WB_ERASE_BUTTON": [WidgetTypes.WIDGET_WB_ERASE_BUTTON],
		"WidgetTypes.WIDGET_WB_EXIT_BUTTON": [WidgetTypes.WIDGET_WB_EXIT_BUTTON],
		"WidgetTypes.WIDGET_WB_UNIT_EDIT_BUTTON": [WidgetTypes.WIDGET_WB_UNIT_EDIT_BUTTON],
		"WidgetTypes.WIDGET_WB_CITY_EDIT_BUTTON": [WidgetTypes.WIDGET_WB_CITY_EDIT_BUTTON],
		"WidgetTypes.WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON": [WidgetTypes.WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON],
		"WidgetTypes.WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON": [WidgetTypes.WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON],
		"WidgetTypes.WIDGET_WB_REVEAL_TAB_MODE_BUTTON": [WidgetTypes.WIDGET_WB_REVEAL_TAB_MODE_BUTTON],
		"WidgetTypes.WIDGET_WB_DIPLOMACY_MODE_BUTTON": [WidgetTypes.WIDGET_WB_DIPLOMACY_MODE_BUTTON],
		"WidgetTypes.WIDGET_WB_REVEAL_ALL_BUTTON": [WidgetTypes.WIDGET_WB_REVEAL_ALL_BUTTON],
		"WidgetTypes.WIDGET_WB_UNREVEAL_ALL_BUTTON": [WidgetTypes.WIDGET_WB_UNREVEAL_ALL_BUTTON],
		"WidgetTypes.WIDGET_WB_REGENERATE_MAP": [WidgetTypes.WIDGET_WB_REGENERATE_MAP],
		"WidgetTypes.WIDGET_AUTOMATE_CITIZENS": [WidgetTypes.WIDGET_AUTOMATE_CITIZENS],
		"WidgetTypes.WIDGET_AUTOMATE_PRODUCTION": [WidgetTypes.WIDGET_AUTOMATE_PRODUCTION],
		"WidgetTypes.WIDGET_EMPHASIZE": [WidgetTypes.WIDGET_EMPHASIZE],
		"WidgetTypes.WIDGET_DIPLOMACY_RESPONSE": [WidgetTypes.WIDGET_DIPLOMACY_RESPONSE],
		"WidgetTypes.WIDGET_GENERAL": [WidgetTypes.WIDGET_GENERAL],
		"WidgetTypes.WIDGET_FILE_LISTBOX": [WidgetTypes.WIDGET_FILE_LISTBOX],
		"WidgetTypes.WIDGET_FILE_EDITBOX": [WidgetTypes.WIDGET_FILE_EDITBOX],
		"WidgetTypes.WIDGET_TRADE_ITEM": [WidgetTypes.WIDGET_TRADE_ITEM],
		"WidgetTypes.WIDGET_UNIT_MODEL": [WidgetTypes.WIDGET_UNIT_MODEL],
		"WidgetTypes.WIDGET_FLAG": [WidgetTypes.WIDGET_FLAG],
		"WidgetTypes.WIDGET_POPUP_QUEUE": [WidgetTypes.WIDGET_POPUP_QUEUE],
		"WidgetTypes.WIDGET_PYTHON": [WidgetTypes.WIDGET_PYTHON],
		"WidgetTypes.WIDGET_HELP_MAINTENANCE": [WidgetTypes.WIDGET_HELP_MAINTENANCE],
		"WidgetTypes.WIDGET_HELP_RELIGION": [WidgetTypes.WIDGET_HELP_RELIGION],
		"WidgetTypes.WIDGET_HELP_RELIGION_CITY": [WidgetTypes.WIDGET_HELP_RELIGION_CITY],
		"WidgetTypes.WIDGET_HELP_CORPORATION_CITY": [WidgetTypes.WIDGET_HELP_CORPORATION_CITY],
		"WidgetTypes.WIDGET_HELP_NATIONALITY": [WidgetTypes.WIDGET_HELP_NATIONALITY],
		"WidgetTypes.WIDGET_HELP_DEFENSE": [WidgetTypes.WIDGET_HELP_DEFENSE],
		"WidgetTypes.WIDGET_HELP_HEALTH": [WidgetTypes.WIDGET_HELP_HEALTH],
		"WidgetTypes.WIDGET_HELP_HAPPINESS": [WidgetTypes.WIDGET_HELP_HAPPINESS],
		"WidgetTypes.WIDGET_HELP_POPULATION": [WidgetTypes.WIDGET_HELP_POPULATION],
		"WidgetTypes.WIDGET_HELP_PRODUCTION": [WidgetTypes.WIDGET_HELP_PRODUCTION],
		"WidgetTypes.WIDGET_HELP_CULTURE": [WidgetTypes.WIDGET_HELP_CULTURE],
		"WidgetTypes.WIDGET_HELP_GREAT_PEOPLE": [WidgetTypes.WIDGET_HELP_GREAT_PEOPLE],
		"WidgetTypes.WIDGET_HELP_GREAT_GENERAL": [WidgetTypes.WIDGET_HELP_GREAT_GENERAL],
		"WidgetTypes.WIDGET_HELP_SELECTED": [WidgetTypes.WIDGET_HELP_SELECTED],
		"WidgetTypes.WIDGET_HELP_BUILDING": [WidgetTypes.WIDGET_HELP_BUILDING],
		"WidgetTypes.WIDGET_HELP_TRADE_ROUTE_CITY": [WidgetTypes.WIDGET_HELP_TRADE_ROUTE_CITY],
		"WidgetTypes.WIDGET_HELP_ESPIONAGE_COST": [WidgetTypes.WIDGET_HELP_ESPIONAGE_COST],
		"WidgetTypes.WIDGET_HELP_TECH_ENTRY": [WidgetTypes.WIDGET_HELP_TECH_ENTRY],
		"WidgetTypes.WIDGET_HELP_TECH_PREPREQ": [WidgetTypes.WIDGET_HELP_TECH_PREPREQ],
		"WidgetTypes.WIDGET_HELP_OBSOLETE": [WidgetTypes.WIDGET_HELP_OBSOLETE],
		"WidgetTypes.WIDGET_HELP_OBSOLETE_BONUS": [WidgetTypes.WIDGET_HELP_OBSOLETE_BONUS],
		"WidgetTypes.WIDGET_HELP_OBSOLETE_SPECIAL": [WidgetTypes.WIDGET_HELP_OBSOLETE_SPECIAL],
		"WidgetTypes.WIDGET_HELP_MOVE_BONUS": [WidgetTypes.WIDGET_HELP_MOVE_BONUS],
		"WidgetTypes.WIDGET_HELP_FREE_UNIT": [WidgetTypes.WIDGET_HELP_FREE_UNIT],
		"WidgetTypes.WIDGET_HELP_FEATURE_PRODUCTION": [WidgetTypes.WIDGET_HELP_FEATURE_PRODUCTION],
		"WidgetTypes.WIDGET_HELP_WORKER_RATE": [WidgetTypes.WIDGET_HELP_WORKER_RATE],
		"WidgetTypes.WIDGET_HELP_TRADE_ROUTES": [WidgetTypes.WIDGET_HELP_TRADE_ROUTES],
		"WidgetTypes.WIDGET_HELP_HEALTH_RATE": [WidgetTypes.WIDGET_HELP_HEALTH_RATE],
		"WidgetTypes.WIDGET_HELP_HAPPINESS_RATE": [WidgetTypes.WIDGET_HELP_HAPPINESS_RATE],
		"WidgetTypes.WIDGET_HELP_FREE_TECH": [WidgetTypes.WIDGET_HELP_FREE_TECH],
		"WidgetTypes.WIDGET_HELP_LOS_BONUS": [WidgetTypes.WIDGET_HELP_LOS_BONUS],
		"WidgetTypes.WIDGET_HELP_MAP_CENTER": [WidgetTypes.WIDGET_HELP_MAP_CENTER],
		"WidgetTypes.WIDGET_HELP_MAP_REVEAL": [WidgetTypes.WIDGET_HELP_MAP_REVEAL],
		"WidgetTypes.WIDGET_HELP_MAP_TRADE": [WidgetTypes.WIDGET_HELP_MAP_TRADE],
		"WidgetTypes.WIDGET_HELP_TECH_TRADE": [WidgetTypes.WIDGET_HELP_TECH_TRADE],
		"WidgetTypes.WIDGET_HELP_GOLD_TRADE": [WidgetTypes.WIDGET_HELP_GOLD_TRADE],
		"WidgetTypes.WIDGET_HELP_OPEN_BORDERS": [WidgetTypes.WIDGET_HELP_OPEN_BORDERS],
		"WidgetTypes.WIDGET_HELP_DEFENSIVE_PACT": [WidgetTypes.WIDGET_HELP_DEFENSIVE_PACT],
		"WidgetTypes.WIDGET_HELP_PERMANENT_ALLIANCE": [WidgetTypes.WIDGET_HELP_PERMANENT_ALLIANCE],
		"WidgetTypes.WIDGET_HELP_VASSAL_STATE": [WidgetTypes.WIDGET_HELP_VASSAL_STATE],
		"WidgetTypes.WIDGET_HELP_BUILD_BRIDGE": [WidgetTypes.WIDGET_HELP_BUILD_BRIDGE],
		"WidgetTypes.WIDGET_HELP_IRRIGATION": [WidgetTypes.WIDGET_HELP_IRRIGATION],
		"WidgetTypes.WIDGET_HELP_IGNORE_IRRIGATION": [WidgetTypes.WIDGET_HELP_IGNORE_IRRIGATION],
		"WidgetTypes.WIDGET_HELP_WATER_WORK": [WidgetTypes.WIDGET_HELP_WATER_WORK],
		"WidgetTypes.WIDGET_HELP_IMPROVEMENT": [WidgetTypes.WIDGET_HELP_IMPROVEMENT],
		"WidgetTypes.WIDGET_HELP_DOMAIN_EXTRA_MOVES": [WidgetTypes.WIDGET_HELP_DOMAIN_EXTRA_MOVES],
		"WidgetTypes.WIDGET_HELP_ADJUST": [WidgetTypes.WIDGET_HELP_ADJUST],
		"WidgetTypes.WIDGET_HELP_TERRAIN_TRADE": [WidgetTypes.WIDGET_HELP_TERRAIN_TRADE],
		"WidgetTypes.WIDGET_HELP_SPECIAL_BUILDING": [WidgetTypes.WIDGET_HELP_SPECIAL_BUILDING],
		"WidgetTypes.WIDGET_HELP_YIELD_CHANGE": [WidgetTypes.WIDGET_HELP_YIELD_CHANGE],
		"WidgetTypes.WIDGET_HELP_BONUS_REVEAL": [WidgetTypes.WIDGET_HELP_BONUS_REVEAL],
		"WidgetTypes.WIDGET_HELP_CIVIC_REVEAL": [WidgetTypes.WIDGET_HELP_CIVIC_REVEAL],
		"WidgetTypes.WIDGET_HELP_PROCESS_INFO": [WidgetTypes.WIDGET_HELP_PROCESS_INFO],
		"WidgetTypes.WIDGET_HELP_FOUND_RELIGION": [WidgetTypes.WIDGET_HELP_FOUND_RELIGION],
		"WidgetTypes.WIDGET_HELP_FOUND_CORPORATION": [WidgetTypes.WIDGET_HELP_FOUND_CORPORATION],
		"WidgetTypes.WIDGET_HELP_FINANCE_NUM_UNITS": [WidgetTypes.WIDGET_HELP_FINANCE_NUM_UNITS],
		"WidgetTypes.WIDGET_HELP_FINANCE_UNIT_COST": [WidgetTypes.WIDGET_HELP_FINANCE_UNIT_COST],
		"WidgetTypes.WIDGET_HELP_FINANCE_AWAY_SUPPLY": [WidgetTypes.WIDGET_HELP_FINANCE_AWAY_SUPPLY],
		"WidgetTypes.WIDGET_HELP_FINANCE_CITY_MAINT": [WidgetTypes.WIDGET_HELP_FINANCE_CITY_MAINT],
		"WidgetTypes.WIDGET_HELP_FINANCE_CIVIC_UPKEEP": [WidgetTypes.WIDGET_HELP_FINANCE_CIVIC_UPKEEP],
		"WidgetTypes.WIDGET_HELP_FINANCE_FOREIGN_INCOME": [WidgetTypes.WIDGET_HELP_FINANCE_FOREIGN_INCOME],
		"WidgetTypes.WIDGET_HELP_FINANCE_INFLATED_COSTS": [WidgetTypes.WIDGET_HELP_FINANCE_INFLATED_COSTS],
		"ButtonPopupTypes.BUTTONPOPUP_TEXT": [ButtonPopupTypes.BUTTONPOPUP_TEXT],
		"ButtonPopupTypes.BUTTONPOPUP_MAIN_MENU": [ButtonPopupTypes.BUTTONPOPUP_MAIN_MENU],
		"ButtonPopupTypes.BUTTONPOPUP_CONFIRM_MENU": [ButtonPopupTypes.BUTTONPOPUP_CONFIRM_MENU],
		"ButtonPopupTypes.BUTTONPOPUP_DECLAREWARMOVE": [ButtonPopupTypes.BUTTONPOPUP_DECLAREWARMOVE],
		"ButtonPopupTypes.BUTTONPOPUP_CONFIRMCOMMAND": [ButtonPopupTypes.BUTTONPOPUP_CONFIRMCOMMAND],
		"ButtonPopupTypes.BUTTONPOPUP_LOADUNIT": [ButtonPopupTypes.BUTTONPOPUP_LOADUNIT],
		"ButtonPopupTypes.BUTTONPOPUP_LEADUNIT": [ButtonPopupTypes.BUTTONPOPUP_LEADUNIT],
		"ButtonPopupTypes.BUTTONPOPUP_DOESPIONAGE": [ButtonPopupTypes.BUTTONPOPUP_DOESPIONAGE],
		"ButtonPopupTypes.BUTTONPOPUP_DOESPIONAGE_TARGET": [ButtonPopupTypes.BUTTONPOPUP_DOESPIONAGE_TARGET],
		"ButtonPopupTypes.BUTTONPOPUP_CHOOSETECH": [ButtonPopupTypes.BUTTONPOPUP_CHOOSETECH],
		"ButtonPopupTypes.BUTTONPOPUP_RAZECITY": [ButtonPopupTypes.BUTTONPOPUP_RAZECITY],
		"ButtonPopupTypes.BUTTONPOPUP_DISBANDCITY": [ButtonPopupTypes.BUTTONPOPUP_DISBANDCITY],
		"ButtonPopupTypes.BUTTONPOPUP_CHOOSEPRODUCTION": [ButtonPopupTypes.BUTTONPOPUP_CHOOSEPRODUCTION],
		"ButtonPopupTypes.BUTTONPOPUP_CHANGECIVIC": [ButtonPopupTypes.BUTTONPOPUP_CHANGECIVIC],
		"ButtonPopupTypes.BUTTONPOPUP_CHANGERELIGION": [ButtonPopupTypes.BUTTONPOPUP_CHANGERELIGION],
		"ButtonPopupTypes.BUTTONPOPUP_CHOOSEELECTION": [ButtonPopupTypes.BUTTONPOPUP_CHOOSEELECTION],
		"ButtonPopupTypes.BUTTONPOPUP_DIPLOVOTE": [ButtonPopupTypes.BUTTONPOPUP_DIPLOVOTE],
		"ButtonPopupTypes.BUTTONPOPUP_ALARM": [ButtonPopupTypes.BUTTONPOPUP_ALARM],
		"ButtonPopupTypes.BUTTONPOPUP_DEAL_CANCELED": [ButtonPopupTypes.BUTTONPOPUP_DEAL_CANCELED],
		"ButtonPopupTypes.BUTTONPOPUP_PYTHON": [ButtonPopupTypes.BUTTONPOPUP_PYTHON],
		"ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN": [ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN],
		"ButtonPopupTypes.BUTTONPOPUP_DETAILS": [ButtonPopupTypes.BUTTONPOPUP_DETAILS],
		"ButtonPopupTypes.BUTTONPOPUP_ADMIN": [ButtonPopupTypes.BUTTONPOPUP_ADMIN],
		"ButtonPopupTypes.BUTTONPOPUP_ADMIN_PASSWORD": [ButtonPopupTypes.BUTTONPOPUP_ADMIN_PASSWORD],
		"ButtonPopupTypes.BUTTONPOPUP_EXTENDED_GAME": [ButtonPopupTypes.BUTTONPOPUP_EXTENDED_GAME],
		"ButtonPopupTypes.BUTTONPOPUP_DIPLOMACY": [ButtonPopupTypes.BUTTONPOPUP_DIPLOMACY],
		"ButtonPopupTypes.BUTTONPOPUP_ADDBUDDY": [ButtonPopupTypes.BUTTONPOPUP_ADDBUDDY],
		"ButtonPopupTypes.BUTTONPOPUP_FORCED_DISCONNECT": [ButtonPopupTypes.BUTTONPOPUP_FORCED_DISCONNECT],
		"ButtonPopupTypes.BUTTONPOPUP_PITBOSS_DISCONNECT": [ButtonPopupTypes.BUTTONPOPUP_PITBOSS_DISCONNECT],
		"ButtonPopupTypes.BUTTONPOPUP_KICKED": [ButtonPopupTypes.BUTTONPOPUP_KICKED],
		"ButtonPopupTypes.BUTTONPOPUP_VASSAL_DEMAND_TRIBUTE": [ButtonPopupTypes.BUTTONPOPUP_VASSAL_DEMAND_TRIBUTE],
		"ButtonPopupTypes.BUTTONPOPUP_VASSAL_GRANT_TRIBUTE": [ButtonPopupTypes.BUTTONPOPUP_VASSAL_GRANT_TRIBUTE],
		"ButtonPopupTypes.BUTTONPOPUP_EVENT": [ButtonPopupTypes.BUTTONPOPUP_EVENT],
		"ButtonPopupTypes.BUTTONPOPUP_FREE_COLONY": [ButtonPopupTypes.BUTTONPOPUP_FREE_COLONY],
		"ButtonPopupTypes.BUTTONPOPUP_LAUNCH": [ButtonPopupTypes.BUTTONPOPUP_LAUNCH],
		"ButtonPopupTypes.BUTTONPOPUP_FOUND_RELIGION": [ButtonPopupTypes.BUTTONPOPUP_FOUND_RELIGION],
		"ButtonPopupTypes.NUM_BUTTONPOPUP_TYPES": [ButtonPopupTypes.NUM_BUTTONPOPUP_TYPES],
		"ClimateTypes.NO_CLIMATE": [ClimateTypes.NO_CLIMATE],
		"SeaLevelTypes.NO_SEALEVEL": [SeaLevelTypes.NO_SEALEVEL],
		"CustomMapOptionTypes.NO_CUSTOM_MAPOPTION": [CustomMapOptionTypes.NO_CUSTOM_MAPOPTION],
		"WorldSizeTypes.NO_WORLDSIZE": [WorldSizeTypes.NO_WORLDSIZE],
		"WorldSizeTypes.WORLDSIZE_DUEL": [WorldSizeTypes.WORLDSIZE_DUEL],
		"WorldSizeTypes.WORLDSIZE_TINY": [WorldSizeTypes.WORLDSIZE_TINY],
		"WorldSizeTypes.WORLDSIZE_SMALL": [WorldSizeTypes.WORLDSIZE_SMALL],
		"WorldSizeTypes.WORLDSIZE_STANDARD": [WorldSizeTypes.WORLDSIZE_STANDARD],
		"WorldSizeTypes.WORLDSIZE_LARGE": [WorldSizeTypes.WORLDSIZE_LARGE],
		"WorldSizeTypes.WORLDSIZE_HUGE": [WorldSizeTypes.WORLDSIZE_HUGE],
		"WorldSizeTypes.NUM_WORLDSIZE_TYPES": [WorldSizeTypes.NUM_WORLDSIZE_TYPES],
		"TerrainTypes.NO_TERRAIN": [TerrainTypes.NO_TERRAIN],
		"PlotTypes.NO_PLOT": [PlotTypes.NO_PLOT],
		"PlotTypes.PLOT_PEAK": [PlotTypes.PLOT_PEAK],
		"PlotTypes.PLOT_HILLS": [PlotTypes.PLOT_HILLS],
		"PlotTypes.PLOT_LAND": [PlotTypes.PLOT_LAND],
		"PlotTypes.PLOT_OCEAN": [PlotTypes.PLOT_OCEAN],
		"PlotTypes.NUM_PLOT_TYPES": [PlotTypes.NUM_PLOT_TYPES],
		"YieldTypes.NO_YIELD": [YieldTypes.NO_YIELD],
		"YieldTypes.YIELD_FOOD": [YieldTypes.YIELD_FOOD],
		"YieldTypes.YIELD_PRODUCTION": [YieldTypes.YIELD_PRODUCTION],
		"YieldTypes.YIELD_COMMERCE": [YieldTypes.YIELD_COMMERCE],
		"YieldTypes.NUM_YIELD_TYPES": [YieldTypes.NUM_YIELD_TYPES],
		"CommerceTypes.COMMERCE_GOLD": [CommerceTypes.COMMERCE_GOLD],
		"CommerceTypes.COMMERCE_RESEARCH": [CommerceTypes.COMMERCE_RESEARCH],
		"CommerceTypes.COMMERCE_CULTURE": [CommerceTypes.COMMERCE_CULTURE],
		"CommerceTypes.COMMERCE_ESPIONAGE": [CommerceTypes.COMMERCE_ESPIONAGE],
		"CommerceTypes.NUM_COMMERCE_TYPES": [CommerceTypes.NUM_COMMERCE_TYPES],
		"AdvisorTypes.NO_ADVISOR": [AdvisorTypes.NO_ADVISOR],
		"FlavorTypes.NO_FLAVOR": [FlavorTypes.NO_FLAVOR],
		"EmphasizeTypes.NO_EMPHASIZE": [EmphasizeTypes.NO_EMPHASIZE],
		"GameOptionTypes.NO_GAMEOPTION": [GameOptionTypes.NO_GAMEOPTION],
		"GameOptionTypes.GAMEOPTION_ADVANCED_START": [GameOptionTypes.GAMEOPTION_ADVANCED_START],
		"GameOptionTypes.GAMEOPTION_NO_CITY_RAZING": [GameOptionTypes.GAMEOPTION_NO_CITY_RAZING],
		"GameOptionTypes.GAMEOPTION_NO_CITY_FLIPPING": [GameOptionTypes.GAMEOPTION_NO_CITY_FLIPPING],
		"GameOptionTypes.GAMEOPTION_FLIPPING_AFTER_CONQUEST": [GameOptionTypes.GAMEOPTION_FLIPPING_AFTER_CONQUEST],
		"GameOptionTypes.GAMEOPTION_NO_BARBARIANS": [GameOptionTypes.GAMEOPTION_NO_BARBARIANS],
		"GameOptionTypes.GAMEOPTION_RAGING_BARBARIANS": [GameOptionTypes.GAMEOPTION_RAGING_BARBARIANS],
		"GameOptionTypes.GAMEOPTION_AGGRESSIVE_AI": [GameOptionTypes.GAMEOPTION_AGGRESSIVE_AI],
		"GameOptionTypes.GAMEOPTION_LEAD_ANY_CIV": [GameOptionTypes.GAMEOPTION_LEAD_ANY_CIV],
		"GameOptionTypes.GAMEOPTION_RANDOM_PERSONALITIES": [GameOptionTypes.GAMEOPTION_RANDOM_PERSONALITIES],
		"GameOptionTypes.GAMEOPTION_PICK_RELIGION": [GameOptionTypes.GAMEOPTION_PICK_RELIGION],
		"GameOptionTypes.GAMEOPTION_NO_TECH_TRADING": [GameOptionTypes.GAMEOPTION_NO_TECH_TRADING],
		"GameOptionTypes.GAMEOPTION_NO_TECH_BROKERING": [GameOptionTypes.GAMEOPTION_NO_TECH_BROKERING],
		"GameOptionTypes.GAMEOPTION_PERMANENT_ALLIANCES": [GameOptionTypes.GAMEOPTION_PERMANENT_ALLIANCES],
		"GameOptionTypes.GAMEOPTION_ALWAYS_WAR": [GameOptionTypes.GAMEOPTION_ALWAYS_WAR],
		"GameOptionTypes.GAMEOPTION_ALWAYS_PEACE": [GameOptionTypes.GAMEOPTION_ALWAYS_PEACE],
		"GameOptionTypes.GAMEOPTION_ONE_CITY_CHALLENGE": [GameOptionTypes.GAMEOPTION_ONE_CITY_CHALLENGE],
		"GameOptionTypes.GAMEOPTION_NO_CHANGING_WAR_PEACE": [GameOptionTypes.GAMEOPTION_NO_CHANGING_WAR_PEACE],
		"GameOptionTypes.GAMEOPTION_NEW_RANDOM_SEED": [GameOptionTypes.GAMEOPTION_NEW_RANDOM_SEED],
		"GameOptionTypes.GAMEOPTION_LOCK_MODS": [GameOptionTypes.GAMEOPTION_LOCK_MODS],
		"GameOptionTypes.GAMEOPTION_COMPLETE_KILLS": [GameOptionTypes.GAMEOPTION_COMPLETE_KILLS],
		"GameOptionTypes.GAMEOPTION_NO_VASSAL_STATES": [GameOptionTypes.GAMEOPTION_NO_VASSAL_STATES],
		"GameOptionTypes.GAMEOPTION_NO_GOODY_HUTS": [GameOptionTypes.GAMEOPTION_NO_GOODY_HUTS],
		"GameOptionTypes.GAMEOPTION_NO_EVENTS": [GameOptionTypes.GAMEOPTION_NO_EVENTS],
		"GameOptionTypes.GAMEOPTION_NO_ESPIONAGE": [GameOptionTypes.GAMEOPTION_NO_ESPIONAGE],
		"GameOptionTypes.GAMEOPTION_NO_DISASTERS": [GameOptionTypes.GAMEOPTION_NO_DISASTERS],
		"GameOptionTypes.GAMEOPTION_MULTIPLE_PRODUCTION": [GameOptionTypes.GAMEOPTION_MULTIPLE_PRODUCTION],
		"GameOptionTypes.NUM_GAMEOPTION_TYPES": [GameOptionTypes.NUM_GAMEOPTION_TYPES],
		"MultiplayerOptionTypes.NO_MPOPTION": [MultiplayerOptionTypes.NO_MPOPTION],
		"MultiplayerOptionTypes.MPOPTION_SIMULTANEOUS_TURNS": [MultiplayerOptionTypes.MPOPTION_SIMULTANEOUS_TURNS],
		"MultiplayerOptionTypes.MPOPTION_TAKEOVER_AI": [MultiplayerOptionTypes.MPOPTION_TAKEOVER_AI],
		"MultiplayerOptionTypes.MPOPTION_SHUFFLE_TEAMS": [MultiplayerOptionTypes.MPOPTION_SHUFFLE_TEAMS],
		"MultiplayerOptionTypes.MPOPTION_ANONYMOUS": [MultiplayerOptionTypes.MPOPTION_ANONYMOUS],
		"MultiplayerOptionTypes.MPOPTION_TURN_TIMER": [MultiplayerOptionTypes.MPOPTION_TURN_TIMER],
		"MultiplayerOptionTypes.NUM_MPOPTION_TYPES": [MultiplayerOptionTypes.NUM_MPOPTION_TYPES],
		"SpecialOptionTypes.NO_SPECIALOPTION": [SpecialOptionTypes.NO_SPECIALOPTION],
		"SpecialOptionTypes.SPECIALOPTION_REPORT_STATS": [SpecialOptionTypes.SPECIALOPTION_REPORT_STATS],
		"SpecialOptionTypes.NUM_SPECIALOPTION_TYPES": [SpecialOptionTypes.NUM_SPECIALOPTION_TYPES],
		"PlayerOptionTypes.NO_PLAYEROPTION": [PlayerOptionTypes.NO_PLAYEROPTION],
		"PlayerOptionTypes.PLAYEROPTION_ADVISOR_POPUPS": [PlayerOptionTypes.PLAYEROPTION_ADVISOR_POPUPS],
		"PlayerOptionTypes.PLAYEROPTION_ADVISOR_HELP": [PlayerOptionTypes.PLAYEROPTION_ADVISOR_HELP],
		"PlayerOptionTypes.PLAYEROPTION_WAIT_END_TURN": [PlayerOptionTypes.PLAYEROPTION_WAIT_END_TURN],
		"PlayerOptionTypes.PLAYEROPTION_MINIMIZE_POP_UPS": [PlayerOptionTypes.PLAYEROPTION_MINIMIZE_POP_UPS],
		"PlayerOptionTypes.PLAYEROPTION_SHOW_FRIENDLY_MOVES": [PlayerOptionTypes.PLAYEROPTION_SHOW_FRIENDLY_MOVES],
		"PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES": [PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES],
		"PlayerOptionTypes.PLAYEROPTION_QUICK_MOVES": [PlayerOptionTypes.PLAYEROPTION_QUICK_MOVES],
		"PlayerOptionTypes.PLAYEROPTION_QUICK_ATTACK": [PlayerOptionTypes.PLAYEROPTION_QUICK_ATTACK],
		"PlayerOptionTypes.PLAYEROPTION_QUICK_DEFENSE": [PlayerOptionTypes.PLAYEROPTION_QUICK_DEFENSE],
		"PlayerOptionTypes.PLAYEROPTION_STACK_ATTACK": [PlayerOptionTypes.PLAYEROPTION_STACK_ATTACK],
		"PlayerOptionTypes.PLAYEROPTION_AUTO_PROMOTION": [PlayerOptionTypes.PLAYEROPTION_AUTO_PROMOTION],
		"PlayerOptionTypes.PLAYEROPTION_START_AUTOMATED": [PlayerOptionTypes.PLAYEROPTION_START_AUTOMATED],
		"PlayerOptionTypes.PLAYEROPTION_SAFE_AUTOMATION": [PlayerOptionTypes.PLAYEROPTION_SAFE_AUTOMATION],
		"PlayerOptionTypes.PLAYEROPTION_NUMPAD_HELP": [PlayerOptionTypes.PLAYEROPTION_NUMPAD_HELP],
		"PlayerOptionTypes.PLAYEROPTION_NO_UNIT_CYCLING": [PlayerOptionTypes.PLAYEROPTION_NO_UNIT_CYCLING],
		"PlayerOptionTypes.PLAYEROPTION_NO_UNIT_RECOMMENDATIONS": [PlayerOptionTypes.PLAYEROPTION_NO_UNIT_RECOMMENDATIONS],
		"PlayerOptionTypes.PLAYEROPTION_RIGHT_CLICK_MENU": [PlayerOptionTypes.PLAYEROPTION_RIGHT_CLICK_MENU],
		"PlayerOptionTypes.PLAYEROPTION_LEAVE_FORESTS": [PlayerOptionTypes.PLAYEROPTION_LEAVE_FORESTS],
		"PlayerOptionTypes.PLAYEROPTION_MISSIONARIES_AUTOMATED": [PlayerOptionTypes.PLAYEROPTION_MISSIONARIES_AUTOMATED],
		"PlayerOptionTypes.PLAYEROPTION_MODDER_1": [PlayerOptionTypes.PLAYEROPTION_MODDER_1],
		"PlayerOptionTypes.PLAYEROPTION_MODDER_2": [PlayerOptionTypes.PLAYEROPTION_MODDER_2],
		"PlayerOptionTypes.PLAYEROPTION_MODDER_3": [PlayerOptionTypes.PLAYEROPTION_MODDER_3],
		#"PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES_PAE_AGGRESSIVE_ANIMALS": [PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES_PAE_AGGRESSIVE_ANIMALS],
		#"PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES_PAE_FRIENDLY_ANIMALS": [PlayerOptionTypes.PLAYEROPTION_SHOW_ENEMY_MOVES_PAE_FRIENDLY_ANIMALS],
		"PlayerOptionTypes.NUM_PLAYEROPTION_TYPES": [PlayerOptionTypes.NUM_PLAYEROPTION_TYPES],
		"GraphicOptionTypes.NO_GRAPHICOPTION": [GraphicOptionTypes.NO_GRAPHICOPTION],
		"GraphicOptionTypes.GRAPHICOPTION_SINGLE_UNIT_GRAPHICS": [GraphicOptionTypes.GRAPHICOPTION_SINGLE_UNIT_GRAPHICS],
		"GraphicOptionTypes.GRAPHICOPTION_HEALTH_BARS": [GraphicOptionTypes.GRAPHICOPTION_HEALTH_BARS],
		"GraphicOptionTypes.GRAPHICOPTION_CITY_DETAIL": [GraphicOptionTypes.GRAPHICOPTION_CITY_DETAIL],
		"GraphicOptionTypes.GRAPHICOPTION_NO_COMBAT_ZOOM": [GraphicOptionTypes.GRAPHICOPTION_NO_COMBAT_ZOOM],
		"GraphicOptionTypes.GRAPHICOPTION_NO_ENEMY_GLOW": [GraphicOptionTypes.GRAPHICOPTION_NO_ENEMY_GLOW],
		"GraphicOptionTypes.GRAPHICOPTION_FROZEN_ANIMATIONS": [GraphicOptionTypes.GRAPHICOPTION_FROZEN_ANIMATIONS],
		"GraphicOptionTypes.GRAPHICOPTION_EFFECTS_DISABLED": [GraphicOptionTypes.GRAPHICOPTION_EFFECTS_DISABLED],
		"GraphicOptionTypes.GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED": [GraphicOptionTypes.GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED],
		"GraphicOptionTypes.GRAPHICOPTION_FULLSCREEN": [GraphicOptionTypes.GRAPHICOPTION_FULLSCREEN],
		"GraphicOptionTypes.GRAPHICOPTION_LOWRES_TEXTURES": [GraphicOptionTypes.GRAPHICOPTION_LOWRES_TEXTURES],
		"GraphicOptionTypes.GRAPHICOPTION_HIRES_TERRAIN": [GraphicOptionTypes.GRAPHICOPTION_HIRES_TERRAIN],
		"GraphicOptionTypes.GRAPHICOPTION_NO_MOVIES": [GraphicOptionTypes.GRAPHICOPTION_NO_MOVIES],
		"GraphicOptionTypes.GRAPHICOPTION_CITY_RADIUS": [GraphicOptionTypes.GRAPHICOPTION_CITY_RADIUS],
		"GraphicOptionTypes.NUM_GRAPHICOPTION_TYPES": [GraphicOptionTypes.NUM_GRAPHICOPTION_TYPES],
		"ForceControlTypes.NO_FORCECONTROL": [ForceControlTypes.NO_FORCECONTROL],
		"ForceControlTypes.FORCECONTROL_SPEED": [ForceControlTypes.FORCECONTROL_SPEED],
		"ForceControlTypes.FORCECONTROL_HANDICAP": [ForceControlTypes.FORCECONTROL_HANDICAP],
		"ForceControlTypes.FORCECONTROL_OPTIONS": [ForceControlTypes.FORCECONTROL_OPTIONS],
		"ForceControlTypes.FORCECONTROL_VICTORIES": [ForceControlTypes.FORCECONTROL_VICTORIES],
		"ForceControlTypes.FORCECONTROL_MAX_TURNS": [ForceControlTypes.FORCECONTROL_MAX_TURNS],
		"ForceControlTypes.FORCECONTROL_MAX_CITY_ELIMINATIONS": [ForceControlTypes.FORCECONTROL_MAX_CITY_ELIMINATIONS],
		"ForceControlTypes.FORCECONTROL_ADVANCED_START": [ForceControlTypes.FORCECONTROL_ADVANCED_START],
		"ForceControlTypes.NUM_FORCECONTROL_TYPES": [ForceControlTypes.NUM_FORCECONTROL_TYPES],
		"VictoryTypes.NO_VICTORY": [VictoryTypes.NO_VICTORY],
		"FeatureTypes.NO_FEATURE": [FeatureTypes.NO_FEATURE],
		"BonusTypes.NO_BONUS": [BonusTypes.NO_BONUS],
		"BonusClassTypes.NO_BONUSCLASS": [BonusClassTypes.NO_BONUSCLASS],
		"ImprovementTypes.NO_IMPROVEMENT": [ImprovementTypes.NO_IMPROVEMENT],
		"RouteTypes.NO_ROUTE": [RouteTypes.NO_ROUTE],
		"RiverTypes.NO_RIVER": [RiverTypes.NO_RIVER],
		"GoodyTypes.NO_GOODY": [GoodyTypes.NO_GOODY],
		"BuildTypes.NO_BUILD": [BuildTypes.NO_BUILD],
		"SymbolTypes.NO_SYMBOL": [SymbolTypes.NO_SYMBOL],
		"FontSymbols.HAPPY_CHAR": [FontSymbols.HAPPY_CHAR],
		"FontSymbols.UNHAPPY_CHAR": [FontSymbols.UNHAPPY_CHAR],
		"FontSymbols.HEALTHY_CHAR": [FontSymbols.HEALTHY_CHAR],
		"FontSymbols.UNHEALTHY_CHAR": [FontSymbols.UNHEALTHY_CHAR],
		"FontSymbols.BULLET_CHAR": [FontSymbols.BULLET_CHAR],
		"FontSymbols.STRENGTH_CHAR": [FontSymbols.STRENGTH_CHAR],
		"FontSymbols.MOVES_CHAR": [FontSymbols.MOVES_CHAR],
		"FontSymbols.RELIGION_CHAR": [FontSymbols.RELIGION_CHAR],
		"FontSymbols.STAR_CHAR": [FontSymbols.STAR_CHAR],
		"FontSymbols.SILVER_STAR_CHAR": [FontSymbols.SILVER_STAR_CHAR],
		"FontSymbols.TRADE_CHAR": [FontSymbols.TRADE_CHAR],
		"FontSymbols.DEFENSE_CHAR": [FontSymbols.DEFENSE_CHAR],
		"FontSymbols.GREAT_PEOPLE_CHAR": [FontSymbols.GREAT_PEOPLE_CHAR],
		"FontSymbols.BAD_GOLD_CHAR": [FontSymbols.BAD_GOLD_CHAR],
		"FontSymbols.BAD_FOOD_CHAR": [FontSymbols.BAD_FOOD_CHAR],
		"FontSymbols.EATEN_FOOD_CHAR": [FontSymbols.EATEN_FOOD_CHAR],
		"FontSymbols.GOLDEN_AGE_CHAR": [FontSymbols.GOLDEN_AGE_CHAR],
		"FontSymbols.ANGRY_POP_CHAR": [FontSymbols.ANGRY_POP_CHAR],
		"FontSymbols.OPEN_BORDERS_CHAR": [FontSymbols.OPEN_BORDERS_CHAR],
		"FontSymbols.DEFENSIVE_PACT_CHAR": [FontSymbols.DEFENSIVE_PACT_CHAR],
		"FontSymbols.MAP_CHAR": [FontSymbols.MAP_CHAR],
		"FontSymbols.OCCUPATION_CHAR": [FontSymbols.OCCUPATION_CHAR],
		"FontSymbols.POWER_CHAR": [FontSymbols.POWER_CHAR],
		"FontSymbols.MAX_NUM_SYMBOLS": [FontSymbols.MAX_NUM_SYMBOLS],
		"HandicapTypes.NO_HANDICAP": [HandicapTypes.NO_HANDICAP],
		"GameSpeedTypes.NO_GAMESPEED": [GameSpeedTypes.NO_GAMESPEED],
		"TurnTimerTypes.NO_TURNTIMER": [TurnTimerTypes.NO_TURNTIMER],
		"EraTypes.NO_ERA": [EraTypes.NO_ERA],
		"CivilizationTypes.NO_CIVILIZATION": [CivilizationTypes.NO_CIVILIZATION],
		"LeaderHeadTypes.NO_LEADER": [LeaderHeadTypes.NO_LEADER],
		"ArtStyleTypes.NO_ARTSTYLE": [ArtStyleTypes.NO_ARTSTYLE],
		"CitySizeTypes.NO_CITYSIZE": [CitySizeTypes.NO_CITYSIZE],
		"CitySizeTypes.CITYSIZE_SMALL": [CitySizeTypes.CITYSIZE_SMALL],
		"CitySizeTypes.CITYSIZE_MEDIUM": [CitySizeTypes.CITYSIZE_MEDIUM],
		"CitySizeTypes.CITYSIZE_LARGE": [CitySizeTypes.CITYSIZE_LARGE],
		"CitySizeTypes.NUM_CITYSIZE_TYPES": [CitySizeTypes.NUM_CITYSIZE_TYPES],
		"FootstepAudioTypes.NO_FOOTSTEPAUDIO": [FootstepAudioTypes.NO_FOOTSTEPAUDIO],
		"FootstepAudioTags.NO_FOOTSTEPAUDIO_TAG": [FootstepAudioTags.NO_FOOTSTEPAUDIO_TAG],
		"ChatTargetTypes.NO_CHATTARGET": [ChatTargetTypes.NO_CHATTARGET],
		"ChatTargetTypes.CHATTARGET_ALL": [ChatTargetTypes.CHATTARGET_ALL],
		"ChatTargetTypes.CHATTARGET_TEAM": [ChatTargetTypes.CHATTARGET_TEAM],
		"VoiceTargetTypes.NO_VOICETARGET": [VoiceTargetTypes.NO_VOICETARGET],
		"VoiceTargetTypes.VOICETARGET_DIPLO": [VoiceTargetTypes.VOICETARGET_DIPLO],
		"VoiceTargetTypes.VOICETARGET_TEAM": [VoiceTargetTypes.VOICETARGET_TEAM],
		"VoiceTargetTypes.VOICETARGET_ALL": [VoiceTargetTypes.VOICETARGET_ALL],
		"VoiceTargetTypes.NUM_VOICETARGETS": [VoiceTargetTypes.NUM_VOICETARGETS],
		"TeamTypes.NO_TEAM": [TeamTypes.NO_TEAM],
		"PlayerTypes.NO_PLAYER": [PlayerTypes.NO_PLAYER],
		"TraitTypes.NO_TRAIT": [TraitTypes.NO_TRAIT],
		"OrderTypes.NO_ORDER": [OrderTypes.NO_ORDER],
		"OrderTypes.ORDER_TRAIN": [OrderTypes.ORDER_TRAIN],
		"OrderTypes.ORDER_CONSTRUCT": [OrderTypes.ORDER_CONSTRUCT],
		"OrderTypes.ORDER_CREATE": [OrderTypes.ORDER_CREATE],
		"OrderTypes.ORDER_MAINTAIN": [OrderTypes.ORDER_MAINTAIN],
		"OrderTypes.NUM_ORDER_TYPES": [OrderTypes.NUM_ORDER_TYPES],
		"TaskTypes.TASK_RAZE": [TaskTypes.TASK_RAZE],
		"TaskTypes.TASK_DISBAND": [TaskTypes.TASK_DISBAND],
		"TaskTypes.TASK_GIFT": [TaskTypes.TASK_GIFT],
		"TaskTypes.TASK_SET_AUTOMATED_CITIZENS": [TaskTypes.TASK_SET_AUTOMATED_CITIZENS],
		"TaskTypes.TASK_SET_AUTOMATED_PRODUCTION": [TaskTypes.TASK_SET_AUTOMATED_PRODUCTION],
		"TaskTypes.TASK_SET_EMPHASIZE": [TaskTypes.TASK_SET_EMPHASIZE],
		"TaskTypes.TASK_CHANGE_SPECIALIST": [TaskTypes.TASK_CHANGE_SPECIALIST],
		"TaskTypes.TASK_CHANGE_WORKING_PLOT": [TaskTypes.TASK_CHANGE_WORKING_PLOT],
		"TaskTypes.TASK_CLEAR_WORKING_OVERRIDE": [TaskTypes.TASK_CLEAR_WORKING_OVERRIDE],
		"TaskTypes.TASK_HURRY": [TaskTypes.TASK_HURRY],
		"TaskTypes.TASK_CONSCRIPT": [TaskTypes.TASK_CONSCRIPT],
		"TaskTypes.TASK_CLEAR_ORDERS": [TaskTypes.TASK_CLEAR_ORDERS],
		"TaskTypes.TASK_RALLY_PLOT": [TaskTypes.TASK_RALLY_PLOT],
		"TaskTypes.TASK_CLEAR_RALLY_PLOT": [TaskTypes.TASK_CLEAR_RALLY_PLOT],
		"TaskTypes.TASK_LIBERATE": [TaskTypes.TASK_LIBERATE],
		"TaskTypes.NUM_TASK_TYPES": [TaskTypes.NUM_TASK_TYPES],
		"BuildingClassTypes.NO_BUILDINGCLASS": [BuildingClassTypes.NO_BUILDINGCLASS],
		"BuildingTypes.NO_BUILDING": [BuildingTypes.NO_BUILDING],
		"SpecialBuildingTypes.NO_SPECIALBUILDING": [SpecialBuildingTypes.NO_SPECIALBUILDING],
		"ProjectTypes.NO_PROJECT": [ProjectTypes.NO_PROJECT],
		"ProcessTypes.NO_PROCESS": [ProcessTypes.NO_PROCESS],
		"VoteTypes.NO_VOTE": [VoteTypes.NO_VOTE],
		"PlayerVoteTypes.NO_PLAYER_VOTE_CHECKED": [PlayerVoteTypes.NO_PLAYER_VOTE_CHECKED],
		"PlayerVoteTypes.PLAYER_VOTE_NEVER": [PlayerVoteTypes.PLAYER_VOTE_NEVER],
		"PlayerVoteTypes.PLAYER_VOTE_ABSTAIN": [PlayerVoteTypes.PLAYER_VOTE_ABSTAIN],
		"PlayerVoteTypes.PLAYER_VOTE_NO": [PlayerVoteTypes.PLAYER_VOTE_NO],
		"PlayerVoteTypes.PLAYER_VOTE_YES": [PlayerVoteTypes.PLAYER_VOTE_YES],
		"PlayerVoteTypes.NO_PLAYER_VOTE": [PlayerVoteTypes.NO_PLAYER_VOTE],
		"InfoBarTypes.INFOBAR_STORED": [InfoBarTypes.INFOBAR_STORED],
		"InfoBarTypes.INFOBAR_RATE": [InfoBarTypes.INFOBAR_RATE],
		"InfoBarTypes.INFOBAR_RATE_EXTRA": [InfoBarTypes.INFOBAR_RATE_EXTRA],
		"InfoBarTypes.INFOBAR_EMPTY": [InfoBarTypes.INFOBAR_EMPTY],
		"InfoBarTypes.NUM_INFOBAR_TYPES": [InfoBarTypes.NUM_INFOBAR_TYPES],
		"HealthBarTypes.HEALTHBAR_ALIVE_ATTACK": [HealthBarTypes.HEALTHBAR_ALIVE_ATTACK],
		"HealthBarTypes.HEALTHBAR_ALIVE_DEFEND": [HealthBarTypes.HEALTHBAR_ALIVE_DEFEND],
		"HealthBarTypes.HEALTHBAR_DEAD": [HealthBarTypes.HEALTHBAR_DEAD],
		"HealthBarTypes.NUM_HEALTHBAR_TYPES": [HealthBarTypes.NUM_HEALTHBAR_TYPES],
		"ConceptTypes.NO_CONCEPT": [ConceptTypes.NO_CONCEPT],
		"NewConceptTypes.NO_NEW_CONCEPT": [NewConceptTypes.NO_NEW_CONCEPT],
		"CalendarTypes.CALENDAR_DEFAULT": [CalendarTypes.CALENDAR_DEFAULT],
		"CalendarTypes.CALENDAR_BI_YEARLY": [CalendarTypes.CALENDAR_BI_YEARLY],
		"CalendarTypes.CALENDAR_YEARS": [CalendarTypes.CALENDAR_YEARS],
		"CalendarTypes.CALENDAR_TURNS": [CalendarTypes.CALENDAR_TURNS],
		"CalendarTypes.CALENDAR_SEASONS": [CalendarTypes.CALENDAR_SEASONS],
		"CalendarTypes.CALENDAR_MONTHS": [CalendarTypes.CALENDAR_MONTHS],
		"CalendarTypes.CALENDAR_WEEKS": [CalendarTypes.CALENDAR_WEEKS],
		"SeasonTypes.NO_SEASON": [SeasonTypes.NO_SEASON],
		"MonthTypes.NO_MONTH": [MonthTypes.NO_MONTH],
		"DenialTypes.NO_DENIAL": [DenialTypes.NO_DENIAL],
		"DenialTypes.DENIAL_UNKNOWN": [DenialTypes.DENIAL_UNKNOWN],
		"DenialTypes.DENIAL_NEVER": [DenialTypes.DENIAL_NEVER],
		"DenialTypes.DENIAL_TOO_MUCH": [DenialTypes.DENIAL_TOO_MUCH],
		"DenialTypes.DENIAL_MYSTERY": [DenialTypes.DENIAL_MYSTERY],
		"DenialTypes.DENIAL_JOKING": [DenialTypes.DENIAL_JOKING],
		"DenialTypes.DENIAL_ANGER_CIVIC": [DenialTypes.DENIAL_ANGER_CIVIC],
		"DenialTypes.DENIAL_FAVORITE_CIVIC": [DenialTypes.DENIAL_FAVORITE_CIVIC],
		"DenialTypes.DENIAL_MINORITY_RELIGION": [DenialTypes.DENIAL_MINORITY_RELIGION],
		"DenialTypes.DENIAL_CONTACT_THEM": [DenialTypes.DENIAL_CONTACT_THEM],
		"DenialTypes.DENIAL_VICTORY": [DenialTypes.DENIAL_VICTORY],
		"DenialTypes.DENIAL_ATTITUDE": [DenialTypes.DENIAL_ATTITUDE],
		"DenialTypes.DENIAL_ATTITUDE_THEM": [DenialTypes.DENIAL_ATTITUDE_THEM],
		"DenialTypes.DENIAL_TECH_WHORE": [DenialTypes.DENIAL_TECH_WHORE],
		"DenialTypes.DENIAL_TECH_MONOPOLY": [DenialTypes.DENIAL_TECH_MONOPOLY],
		"DenialTypes.DENIAL_POWER_US": [DenialTypes.DENIAL_POWER_US],
		"DenialTypes.DENIAL_POWER_YOU": [DenialTypes.DENIAL_POWER_YOU],
		"DenialTypes.DENIAL_POWER_THEM": [DenialTypes.DENIAL_POWER_THEM],
		"DenialTypes.DENIAL_TOO_MANY_WARS": [DenialTypes.DENIAL_TOO_MANY_WARS],
		"DenialTypes.DENIAL_NO_GAIN": [DenialTypes.DENIAL_NO_GAIN],
		"DenialTypes.DENIAL_NOT_ALLIED": [DenialTypes.DENIAL_NOT_ALLIED],
		"DenialTypes.DENIAL_RECENT_CANCEL": [DenialTypes.DENIAL_RECENT_CANCEL],
		"DenialTypes.DENIAL_WORST_ENEMY": [DenialTypes.DENIAL_WORST_ENEMY],
		"DenialTypes.DENIAL_POWER_YOUR_ENEMIES": [DenialTypes.DENIAL_POWER_YOUR_ENEMIES],
		"DenialTypes.DENIAL_TOO_FAR": [DenialTypes.DENIAL_TOO_FAR],
		"DomainTypes.DOMAIN_SEA": [DomainTypes.DOMAIN_SEA],
		"DomainTypes.DOMAIN_AIR": [DomainTypes.DOMAIN_AIR],
		"DomainTypes.DOMAIN_LAND": [DomainTypes.DOMAIN_LAND],
		"DomainTypes.DOMAIN_IMMOBILE": [DomainTypes.DOMAIN_IMMOBILE],
		"DomainTypes.NUM_DOMAIN_TYPES": [DomainTypes.NUM_DOMAIN_TYPES],
		"UnitClassTypes.NO_UNITCLASS": [UnitClassTypes.NO_UNITCLASS],
		"UnitTypes.NO_UNIT": [UnitTypes.NO_UNIT],
		"SpecialUnitTypes.NO_SPECIALUNIT": [SpecialUnitTypes.NO_SPECIALUNIT],
		"UnitCombatTypes.NO_UNITCOMBAT": [UnitCombatTypes.NO_UNITCOMBAT],
		"UnitAITypes.NO_UNITAI": [UnitAITypes.NO_UNITAI],
		"UnitAITypes.UNITAI_UNKNOWN": [UnitAITypes.UNITAI_UNKNOWN],
		"UnitAITypes.UNITAI_ANIMAL": [UnitAITypes.UNITAI_ANIMAL],
		"UnitAITypes.UNITAI_SETTLE": [UnitAITypes.UNITAI_SETTLE],
		"UnitAITypes.UNITAI_WORKER": [UnitAITypes.UNITAI_WORKER],
		"UnitAITypes.UNITAI_ATTACK": [UnitAITypes.UNITAI_ATTACK],
		"UnitAITypes.UNITAI_ATTACK_CITY": [UnitAITypes.UNITAI_ATTACK_CITY],
		"UnitAITypes.UNITAI_COLLATERAL": [UnitAITypes.UNITAI_COLLATERAL],
		"UnitAITypes.UNITAI_PILLAGE": [UnitAITypes.UNITAI_PILLAGE],
		"UnitAITypes.UNITAI_RESERVE": [UnitAITypes.UNITAI_RESERVE],
		"UnitAITypes.UNITAI_COUNTER": [UnitAITypes.UNITAI_COUNTER],
		"UnitAITypes.UNITAI_CITY_DEFENSE": [UnitAITypes.UNITAI_CITY_DEFENSE],
		"UnitAITypes.UNITAI_CITY_COUNTER": [UnitAITypes.UNITAI_CITY_COUNTER],
		"UnitAITypes.UNITAI_CITY_SPECIAL": [UnitAITypes.UNITAI_CITY_SPECIAL],
		"UnitAITypes.UNITAI_EXPLORE": [UnitAITypes.UNITAI_EXPLORE],
		"UnitAITypes.UNITAI_MISSIONARY": [UnitAITypes.UNITAI_MISSIONARY],
		"UnitAITypes.UNITAI_PROPHET": [UnitAITypes.UNITAI_PROPHET],
		"UnitAITypes.UNITAI_ARTIST": [UnitAITypes.UNITAI_ARTIST],
		"UnitAITypes.UNITAI_SCIENTIST": [UnitAITypes.UNITAI_SCIENTIST],
		"UnitAITypes.UNITAI_GENERAL": [UnitAITypes.UNITAI_GENERAL],
		"UnitAITypes.UNITAI_MERCHANT": [UnitAITypes.UNITAI_MERCHANT],
		"UnitAITypes.UNITAI_ENGINEER": [UnitAITypes.UNITAI_ENGINEER],
		"UnitAITypes.UNITAI_SPY": [UnitAITypes.UNITAI_SPY],
		"UnitAITypes.UNITAI_ICBM": [UnitAITypes.UNITAI_ICBM],
		"UnitAITypes.UNITAI_WORKER_SEA": [UnitAITypes.UNITAI_WORKER_SEA],
		"UnitAITypes.UNITAI_ATTACK_SEA": [UnitAITypes.UNITAI_ATTACK_SEA],
		"UnitAITypes.UNITAI_RESERVE_SEA": [UnitAITypes.UNITAI_RESERVE_SEA],
		"UnitAITypes.UNITAI_ESCORT_SEA": [UnitAITypes.UNITAI_ESCORT_SEA],
		"UnitAITypes.UNITAI_EXPLORE_SEA": [UnitAITypes.UNITAI_EXPLORE_SEA],
		"UnitAITypes.UNITAI_ASSAULT_SEA": [UnitAITypes.UNITAI_ASSAULT_SEA],
		"UnitAITypes.UNITAI_SETTLER_SEA": [UnitAITypes.UNITAI_SETTLER_SEA],
		"UnitAITypes.UNITAI_MISSIONARY_SEA": [UnitAITypes.UNITAI_MISSIONARY_SEA],
		"UnitAITypes.UNITAI_SPY_SEA": [UnitAITypes.UNITAI_SPY_SEA],
		"UnitAITypes.UNITAI_CARRIER_SEA": [UnitAITypes.UNITAI_CARRIER_SEA],
		"UnitAITypes.UNITAI_MISSILE_CARRIER_SEA": [UnitAITypes.UNITAI_MISSILE_CARRIER_SEA],
		"UnitAITypes.UNITAI_PIRATE_SEA": [UnitAITypes.UNITAI_PIRATE_SEA],
		"UnitAITypes.UNITAI_ATTACK_AIR": [UnitAITypes.UNITAI_ATTACK_AIR],
		"UnitAITypes.UNITAI_DEFENSE_AIR": [UnitAITypes.UNITAI_DEFENSE_AIR],
		"UnitAITypes.UNITAI_CARRIER_AIR": [UnitAITypes.UNITAI_CARRIER_AIR],
		"UnitAITypes.UNITAI_MISSILE_AIR": [UnitAITypes.UNITAI_MISSILE_AIR],
		"UnitAITypes.UNITAI_PARADROP": [UnitAITypes.UNITAI_PARADROP],
		"UnitAITypes.UNITAI_ATTACK_CITY_LEMMING": [UnitAITypes.UNITAI_ATTACK_CITY_LEMMING],
		"UnitAITypes.NUM_UNITAI_TYPES": [UnitAITypes.NUM_UNITAI_TYPES],
		"InvisibleTypes.NO_INVISIBLE": [InvisibleTypes.NO_INVISIBLE],
		"VoteSourceTypes.NO_VOTESOURCE": [VoteSourceTypes.NO_VOTESOURCE],
		"ProbabilityTypes.NO_PROBABILITY": [ProbabilityTypes.NO_PROBABILITY],
		"ProbabilityTypes.PROBABILITY_LOW": [ProbabilityTypes.PROBABILITY_LOW],
		"ProbabilityTypes.PROBABILITY_REAL": [ProbabilityTypes.PROBABILITY_REAL],
		"ProbabilityTypes.PROBABILITY_HIGH": [ProbabilityTypes.PROBABILITY_HIGH],
		"ActivityTypes.NO_ACTIVITY": [ActivityTypes.NO_ACTIVITY],
		"ActivityTypes.ACTIVITY_AWAKE": [ActivityTypes.ACTIVITY_AWAKE],
		"ActivityTypes.ACTIVITY_HOLD": [ActivityTypes.ACTIVITY_HOLD],
		"ActivityTypes.ACTIVITY_SLEEP": [ActivityTypes.ACTIVITY_SLEEP],
		"ActivityTypes.ACTIVITY_HEAL": [ActivityTypes.ACTIVITY_HEAL],
		"ActivityTypes.ACTIVITY_SENTRY": [ActivityTypes.ACTIVITY_SENTRY],
		"ActivityTypes.ACTIVITY_INTERCEPT": [ActivityTypes.ACTIVITY_INTERCEPT],
		"ActivityTypes.ACTIVITY_MISSION": [ActivityTypes.ACTIVITY_MISSION],
		"ActivityTypes.ACTIVITY_PATROL": [ActivityTypes.ACTIVITY_PATROL],
		"ActivityTypes.ACTIVITY_PLUNDER": [ActivityTypes.ACTIVITY_PLUNDER],
		"ActivityTypes.NUM_ACTIVITY_TYPES": [ActivityTypes.NUM_ACTIVITY_TYPES],
		"AutomateTypes.NO_AUTOMATE": [AutomateTypes.NO_AUTOMATE],
		"AutomateTypes.AUTOMATE_BUILD": [AutomateTypes.AUTOMATE_BUILD],
		"AutomateTypes.AUTOMATE_NETWORK": [AutomateTypes.AUTOMATE_NETWORK],
		"AutomateTypes.AUTOMATE_CITY": [AutomateTypes.AUTOMATE_CITY],
		"AutomateTypes.AUTOMATE_EXPLORE": [AutomateTypes.AUTOMATE_EXPLORE],
		"AutomateTypes.AUTOMATE_RELIGION": [AutomateTypes.AUTOMATE_RELIGION],
		"AutomateTypes.NUM_AUTOMATE_TYPES": [AutomateTypes.NUM_AUTOMATE_TYPES],
		"MissionTypes.NO_MISSION": [MissionTypes.NO_MISSION],
		"MissionTypes.MISSION_MOVE_TO": [MissionTypes.MISSION_MOVE_TO],
		"MissionTypes.MISSION_ROUTE_TO": [MissionTypes.MISSION_ROUTE_TO],
		"MissionTypes.MISSION_MOVE_TO_UNIT": [MissionTypes.MISSION_MOVE_TO_UNIT],
		"MissionTypes.MISSION_SKIP": [MissionTypes.MISSION_SKIP],
		"MissionTypes.MISSION_SLEEP": [MissionTypes.MISSION_SLEEP],
		"MissionTypes.MISSION_FORTIFY": [MissionTypes.MISSION_FORTIFY],
		"MissionTypes.MISSION_PLUNDER": [MissionTypes.MISSION_PLUNDER],
		"MissionTypes.MISSION_AIRPATROL": [MissionTypes.MISSION_AIRPATROL],
		"MissionTypes.MISSION_SEAPATROL": [MissionTypes.MISSION_SEAPATROL],
		"MissionTypes.MISSION_HEAL": [MissionTypes.MISSION_HEAL],
		"MissionTypes.MISSION_SENTRY": [MissionTypes.MISSION_SENTRY],
		"MissionTypes.MISSION_AIRLIFT": [MissionTypes.MISSION_AIRLIFT],
		"MissionTypes.MISSION_NUKE": [MissionTypes.MISSION_NUKE],
		"MissionTypes.MISSION_RECON": [MissionTypes.MISSION_RECON],
		"MissionTypes.MISSION_PARADROP": [MissionTypes.MISSION_PARADROP],
		"MissionTypes.MISSION_AIRBOMB": [MissionTypes.MISSION_AIRBOMB],
		"MissionTypes.MISSION_RANGE_ATTACK": [MissionTypes.MISSION_RANGE_ATTACK],
		"MissionTypes.MISSION_BOMBARD": [MissionTypes.MISSION_BOMBARD],
		"MissionTypes.MISSION_PILLAGE": [MissionTypes.MISSION_PILLAGE],
		"MissionTypes.MISSION_SABOTAGE": [MissionTypes.MISSION_SABOTAGE],
		"MissionTypes.MISSION_DESTROY": [MissionTypes.MISSION_DESTROY],
		"MissionTypes.MISSION_STEAL_PLANS": [MissionTypes.MISSION_STEAL_PLANS],
		"MissionTypes.MISSION_FOUND": [MissionTypes.MISSION_FOUND],
		"MissionTypes.MISSION_SPREAD": [MissionTypes.MISSION_SPREAD],
		"MissionTypes.MISSION_SPREAD_CORPORATION": [MissionTypes.MISSION_SPREAD_CORPORATION],
		"MissionTypes.MISSION_JOIN": [MissionTypes.MISSION_JOIN],
		"MissionTypes.MISSION_CONSTRUCT": [MissionTypes.MISSION_CONSTRUCT],
		"MissionTypes.MISSION_DISCOVER": [MissionTypes.MISSION_DISCOVER],
		"MissionTypes.MISSION_HURRY": [MissionTypes.MISSION_HURRY],
		"MissionTypes.MISSION_TRADE": [MissionTypes.MISSION_TRADE],
		"MissionTypes.MISSION_GREAT_WORK": [MissionTypes.MISSION_GREAT_WORK],
		"MissionTypes.MISSION_INFILTRATE": [MissionTypes.MISSION_INFILTRATE],
		"MissionTypes.MISSION_LEAD": [MissionTypes.MISSION_LEAD],
		"MissionTypes.MISSION_ESPIONAGE": [MissionTypes.MISSION_ESPIONAGE],
		"MissionTypes.MISSION_GOLDEN_AGE": [MissionTypes.MISSION_GOLDEN_AGE],
		"MissionTypes.MISSION_BUILD": [MissionTypes.MISSION_BUILD],
		"MissionTypes.MISSION_BEGIN_COMBAT": [MissionTypes.MISSION_BEGIN_COMBAT],
		"MissionTypes.MISSION_END_COMBAT": [MissionTypes.MISSION_END_COMBAT],
		"MissionTypes.MISSION_AIRSTRIKE": [MissionTypes.MISSION_AIRSTRIKE],
		"MissionTypes.MISSION_SURRENDER": [MissionTypes.MISSION_SURRENDER],
		"MissionTypes.MISSION_CAPTURED": [MissionTypes.MISSION_CAPTURED],
		"MissionTypes.MISSION_IDLE": [MissionTypes.MISSION_IDLE],
		"MissionTypes.MISSION_DIE": [MissionTypes.MISSION_DIE],
		"MissionTypes.MISSION_DAMAGE": [MissionTypes.MISSION_DAMAGE],
		"MissionTypes.MISSION_MULTI_SELECT": [MissionTypes.MISSION_MULTI_SELECT],
		"MissionTypes.MISSION_MULTI_DESELECT": [MissionTypes.MISSION_MULTI_DESELECT],
		"MissionTypes.NUM_MISSION_TYPES": [MissionTypes.NUM_MISSION_TYPES],
		"MissionAITypes.NO_MISSIONAI": [MissionAITypes.NO_MISSIONAI],
		"MissionAITypes.MISSIONAI_SHADOW": [MissionAITypes.MISSIONAI_SHADOW],
		"MissionAITypes.MISSIONAI_GROUP": [MissionAITypes.MISSIONAI_GROUP],
		"MissionAITypes.MISSIONAI_LOAD_ASSAULT": [MissionAITypes.MISSIONAI_LOAD_ASSAULT],
		"MissionAITypes.MISSIONAI_LOAD_SETTLER": [MissionAITypes.MISSIONAI_LOAD_SETTLER],
		"MissionAITypes.MISSIONAI_LOAD_SPECIAL": [MissionAITypes.MISSIONAI_LOAD_SPECIAL],
		"MissionAITypes.MISSIONAI_GUARD_CITY": [MissionAITypes.MISSIONAI_GUARD_CITY],
		"MissionAITypes.MISSIONAI_GUARD_BONUS": [MissionAITypes.MISSIONAI_GUARD_BONUS],
		"MissionAITypes.MISSIONAI_GUARD_TRADE_NET": [MissionAITypes.MISSIONAI_GUARD_TRADE_NET],
		"MissionAITypes.MISSIONAI_GUARD_SPY": [MissionAITypes.MISSIONAI_GUARD_SPY],
		"MissionAITypes.MISSIONAI_ATTACK_SPY": [MissionAITypes.MISSIONAI_ATTACK_SPY],
		"MissionAITypes.MISSIONAI_SPREAD": [MissionAITypes.MISSIONAI_SPREAD],
		"MissionAITypes.MISSIONAI_SPREAD_CORPORATION": [MissionAITypes.MISSIONAI_SPREAD_CORPORATION],
		"MissionAITypes.MISSIONAI_CONSTRUCT": [MissionAITypes.MISSIONAI_CONSTRUCT],
		"MissionAITypes.MISSIONAI_HURRY": [MissionAITypes.MISSIONAI_HURRY],
		"MissionAITypes.MISSIONAI_GREAT_WORK": [MissionAITypes.MISSIONAI_GREAT_WORK],
		"MissionAITypes.MISSIONAI_EXPLORE": [MissionAITypes.MISSIONAI_EXPLORE],
		"MissionAITypes.MISSIONAI_BLOCKADE": [MissionAITypes.MISSIONAI_BLOCKADE],
		"MissionAITypes.MISSIONAI_PILLAGE": [MissionAITypes.MISSIONAI_PILLAGE],
		"MissionAITypes.MISSIONAI_FOUND": [MissionAITypes.MISSIONAI_FOUND],
		"MissionAITypes.MISSIONAI_BUILD": [MissionAITypes.MISSIONAI_BUILD],
		"MissionAITypes.MISSIONAI_ASSAULT": [MissionAITypes.MISSIONAI_ASSAULT],
		"MissionAITypes.MISSIONAI_CARRIER": [MissionAITypes.MISSIONAI_CARRIER],
		"MissionAITypes.MISSIONAI_PICKUP": [MissionAITypes.MISSIONAI_PICKUP],
		"CommandTypes.NO_COMMAND": [CommandTypes.NO_COMMAND],
		"CommandTypes.COMMAND_PROMOTION": [CommandTypes.COMMAND_PROMOTION],
		"CommandTypes.COMMAND_UPGRADE": [CommandTypes.COMMAND_UPGRADE],
		"CommandTypes.COMMAND_AUTOMATE": [CommandTypes.COMMAND_AUTOMATE],
		"CommandTypes.COMMAND_WAKE": [CommandTypes.COMMAND_WAKE],
		"CommandTypes.COMMAND_CANCEL": [CommandTypes.COMMAND_CANCEL],
		"CommandTypes.COMMAND_CANCEL_ALL": [CommandTypes.COMMAND_CANCEL_ALL],
		"CommandTypes.COMMAND_STOP_AUTOMATION": [CommandTypes.COMMAND_STOP_AUTOMATION],
		"CommandTypes.COMMAND_DELETE": [CommandTypes.COMMAND_DELETE],
		"CommandTypes.COMMAND_GIFT": [CommandTypes.COMMAND_GIFT],
		"CommandTypes.COMMAND_LOAD": [CommandTypes.COMMAND_LOAD],
		"CommandTypes.COMMAND_LOAD_UNIT": [CommandTypes.COMMAND_LOAD_UNIT],
		"CommandTypes.COMMAND_UNLOAD": [CommandTypes.COMMAND_UNLOAD],
		"CommandTypes.COMMAND_UNLOAD_ALL": [CommandTypes.COMMAND_UNLOAD_ALL],
		"CommandTypes.COMMAND_HOTKEY": [CommandTypes.COMMAND_HOTKEY],
		"CommandTypes.NUM_COMMAND_TYPES": [CommandTypes.NUM_COMMAND_TYPES],
		"ControlTypes.NO_CONTROL": [ControlTypes.NO_CONTROL],
		"ControlTypes.CONTROL_CENTERONSELECTION": [ControlTypes.CONTROL_CENTERONSELECTION],
		"ControlTypes.CONTROL_SELECTYUNITTYPE": [ControlTypes.CONTROL_SELECTYUNITTYPE],
		"ControlTypes.CONTROL_SELECTYUNITALL": [ControlTypes.CONTROL_SELECTYUNITALL],
		"ControlTypes.CONTROL_SELECTCITY": [ControlTypes.CONTROL_SELECTCITY],
		"ControlTypes.CONTROL_SELECTCAPITAL": [ControlTypes.CONTROL_SELECTCAPITAL],
		"ControlTypes.CONTROL_NEXTCITY": [ControlTypes.CONTROL_NEXTCITY],
		"ControlTypes.CONTROL_PREVCITY": [ControlTypes.CONTROL_PREVCITY],
		"ControlTypes.CONTROL_NEXTUNIT": [ControlTypes.CONTROL_NEXTUNIT],
		"ControlTypes.CONTROL_PREVUNIT": [ControlTypes.CONTROL_PREVUNIT],
		"ControlTypes.CONTROL_CYCLEUNIT": [ControlTypes.CONTROL_CYCLEUNIT],
		"ControlTypes.CONTROL_CYCLEUNIT_ALT": [ControlTypes.CONTROL_CYCLEUNIT_ALT],
		"ControlTypes.CONTROL_CYCLEWORKER": [ControlTypes.CONTROL_CYCLEWORKER],
		"ControlTypes.CONTROL_LASTUNIT": [ControlTypes.CONTROL_LASTUNIT],
		"ControlTypes.CONTROL_ENDTURN": [ControlTypes.CONTROL_ENDTURN],
		"ControlTypes.CONTROL_ENDTURN_ALT": [ControlTypes.CONTROL_ENDTURN_ALT],
		"ControlTypes.CONTROL_FORCEENDTURN": [ControlTypes.CONTROL_FORCEENDTURN],
		"ControlTypes.CONTROL_AUTOMOVES": [ControlTypes.CONTROL_AUTOMOVES],
		"ControlTypes.CONTROL_PING": [ControlTypes.CONTROL_PING],
		"ControlTypes.CONTROL_SIGN": [ControlTypes.CONTROL_SIGN],
		"ControlTypes.CONTROL_GRID": [ControlTypes.CONTROL_GRID],
		"ControlTypes.CONTROL_BARE_MAP": [ControlTypes.CONTROL_BARE_MAP],
		"ControlTypes.CONTROL_YIELDS": [ControlTypes.CONTROL_YIELDS],
		"ControlTypes.CONTROL_RESOURCE_ALL": [ControlTypes.CONTROL_RESOURCE_ALL],
		"ControlTypes.CONTROL_UNIT_ICONS": [ControlTypes.CONTROL_UNIT_ICONS],
		"ControlTypes.CONTROL_GLOBELAYER": [ControlTypes.CONTROL_GLOBELAYER],
		"ControlTypes.CONTROL_SCORES": [ControlTypes.CONTROL_SCORES],
		"ControlTypes.CONTROL_LOAD_GAME": [ControlTypes.CONTROL_LOAD_GAME],
		"ControlTypes.CONTROL_OPTIONS_SCREEN": [ControlTypes.CONTROL_OPTIONS_SCREEN],
		"ControlTypes.CONTROL_RETIRE": [ControlTypes.CONTROL_RETIRE],
		"ControlTypes.CONTROL_SAVE_GROUP": [ControlTypes.CONTROL_SAVE_GROUP],
		"ControlTypes.CONTROL_SAVE_NORMAL": [ControlTypes.CONTROL_SAVE_NORMAL],
		"ControlTypes.CONTROL_QUICK_SAVE": [ControlTypes.CONTROL_QUICK_SAVE],
		"ControlTypes.CONTROL_QUICK_LOAD": [ControlTypes.CONTROL_QUICK_LOAD],
		"ControlTypes.CONTROL_ORTHO_CAMERA": [ControlTypes.CONTROL_ORTHO_CAMERA],
		"ControlTypes.CONTROL_CYCLE_CAMERA_FLYING_MODES": [ControlTypes.CONTROL_CYCLE_CAMERA_FLYING_MODES],
		"ControlTypes.CONTROL_ISOMETRIC_CAMERA_LEFT": [ControlTypes.CONTROL_ISOMETRIC_CAMERA_LEFT],
		"ControlTypes.CONTROL_ISOMETRIC_CAMERA_RIGHT": [ControlTypes.CONTROL_ISOMETRIC_CAMERA_RIGHT],
		"ControlTypes.CONTROL_FLYING_CAMERA": [ControlTypes.CONTROL_FLYING_CAMERA],
		"ControlTypes.CONTROL_MOUSE_FLYING_CAMERA": [ControlTypes.CONTROL_MOUSE_FLYING_CAMERA],
		"ControlTypes.CONTROL_TOP_DOWN_CAMERA": [ControlTypes.CONTROL_TOP_DOWN_CAMERA],
		"ControlTypes.CONTROL_CIVILOPEDIA": [ControlTypes.CONTROL_CIVILOPEDIA],
		"ControlTypes.CONTROL_RELIGION_SCREEN": [ControlTypes.CONTROL_RELIGION_SCREEN],
		"ControlTypes.CONTROL_CORPORATION_SCREEN": [ControlTypes.CONTROL_CORPORATION_SCREEN],
		"ControlTypes.CONTROL_CIVICS_SCREEN": [ControlTypes.CONTROL_CIVICS_SCREEN],
		"ControlTypes.CONTROL_FOREIGN_SCREEN": [ControlTypes.CONTROL_FOREIGN_SCREEN],
		"ControlTypes.CONTROL_FINANCIAL_SCREEN": [ControlTypes.CONTROL_FINANCIAL_SCREEN],
		"ControlTypes.CONTROL_MILITARY_SCREEN": [ControlTypes.CONTROL_MILITARY_SCREEN],
		"ControlTypes.CONTROL_TECH_CHOOSER": [ControlTypes.CONTROL_TECH_CHOOSER],
		"ControlTypes.CONTROL_TURN_LOG": [ControlTypes.CONTROL_TURN_LOG],
		"ControlTypes.CONTROL_CHAT_ALL": [ControlTypes.CONTROL_CHAT_ALL],
		"ControlTypes.CONTROL_CHAT_TEAM": [ControlTypes.CONTROL_CHAT_TEAM],
		"ControlTypes.CONTROL_DOMESTIC_SCREEN": [ControlTypes.CONTROL_DOMESTIC_SCREEN],
		"ControlTypes.CONTROL_VICTORY_SCREEN": [ControlTypes.CONTROL_VICTORY_SCREEN],
		"ControlTypes.CONTROL_INFO": [ControlTypes.CONTROL_INFO],
		"ControlTypes.CONTROL_GLOBE_VIEW": [ControlTypes.CONTROL_GLOBE_VIEW],
		"ControlTypes.CONTROL_DETAILS": [ControlTypes.CONTROL_DETAILS],
		"ControlTypes.CONTROL_ADMIN_DETAILS": [ControlTypes.CONTROL_ADMIN_DETAILS],
		"ControlTypes.CONTROL_HALL_OF_FAME": [ControlTypes.CONTROL_HALL_OF_FAME],
		"ControlTypes.CONTROL_WORLD_BUILDER": [ControlTypes.CONTROL_WORLD_BUILDER],
		"ControlTypes.CONTROL_DIPLOMACY": [ControlTypes.CONTROL_DIPLOMACY],
		"ControlTypes.CONTROL_SELECT_HEALTHY": [ControlTypes.CONTROL_SELECT_HEALTHY],
		"ControlTypes.CONTROL_ESPIONAGE_SCREEN": [ControlTypes.CONTROL_ESPIONAGE_SCREEN],
		"ControlTypes.CONTROL_FREE_COLONY": [ControlTypes.CONTROL_FREE_COLONY],
		"ControlTypes.NUM_CONTROL_TYPES": [ControlTypes.NUM_CONTROL_TYPES],
		"PromotionTypes.NO_PROMOTION": [PromotionTypes.NO_PROMOTION],
		"TechTypes.NO_TECH": [TechTypes.NO_TECH],
		"SpecialistTypes.NO_SPECIALIST": [SpecialistTypes.NO_SPECIALIST],
		"ReligionTypes.NO_RELIGION": [ReligionTypes.NO_RELIGION],
		"CorporationTypes.NO_CORPORATION": [CorporationTypes.NO_CORPORATION],
		"HurryTypes.NO_HURRY": [HurryTypes.NO_HURRY],
		"UpkeepTypes.NO_UPKEEP": [UpkeepTypes.NO_UPKEEP],
		"CultureLevelTypes.NO_CULTURELEVEL": [CultureLevelTypes.NO_CULTURELEVEL],
		"CivicOptionTypes.NO_CIVICOPTION": [CivicOptionTypes.NO_CIVICOPTION],
		"CivicTypes.NO_CIVIC": [CivicTypes.NO_CIVIC],
		"WarPlanTypes.NO_WARPLAN": [WarPlanTypes.NO_WARPLAN],
		"WarPlanTypes.WARPLAN_ATTACKED_RECENT": [WarPlanTypes.WARPLAN_ATTACKED_RECENT],
		"WarPlanTypes.WARPLAN_ATTACKED": [WarPlanTypes.WARPLAN_ATTACKED],
		"WarPlanTypes.WARPLAN_PREPARING_LIMITED": [WarPlanTypes.WARPLAN_PREPARING_LIMITED],
		"WarPlanTypes.WARPLAN_PREPARING_TOTAL": [WarPlanTypes.WARPLAN_PREPARING_TOTAL],
		"WarPlanTypes.WARPLAN_LIMITED": [WarPlanTypes.WARPLAN_LIMITED],
		"WarPlanTypes.WARPLAN_TOTAL": [WarPlanTypes.WARPLAN_TOTAL],
		"WarPlanTypes.WARPLAN_DOGPILE": [WarPlanTypes.WARPLAN_DOGPILE],
		"AreaAITypes.NO_AREAAI": [AreaAITypes.NO_AREAAI],
		"AreaAITypes.AREAAI_OFFENSIVE": [AreaAITypes.AREAAI_OFFENSIVE],
		"AreaAITypes.AREAAI_DEFENSIVE": [AreaAITypes.AREAAI_DEFENSIVE],
		"AreaAITypes.AREAAI_MASSING": [AreaAITypes.AREAAI_MASSING],
		"AreaAITypes.AREAAI_ASSAULT": [AreaAITypes.AREAAI_ASSAULT],
		"AreaAITypes.AREAAI_NEUTRAL": [AreaAITypes.AREAAI_NEUTRAL],
		"EndTurnButtonStates.END_TURN_GO": [EndTurnButtonStates.END_TURN_GO],
		"EndTurnButtonStates.END_TURN_OVER_HIGHLIGHT": [EndTurnButtonStates.END_TURN_OVER_HIGHLIGHT],
		"EndTurnButtonStates.END_TURN_OVER_DARK": [EndTurnButtonStates.END_TURN_OVER_DARK],
		"EndTurnButtonStates.NUM_END_TURN_STATES": [EndTurnButtonStates.NUM_END_TURN_STATES],
		"FogOfWarModeTypes.FOGOFWARMODE_OFF": [FogOfWarModeTypes.FOGOFWARMODE_OFF],
		"FogOfWarModeTypes.FOGOFWARMODE_UNEXPLORED": [FogOfWarModeTypes.FOGOFWARMODE_UNEXPLORED],
		"FogOfWarModeTypes.NUM_FOGOFWARMODE_TYPES": [FogOfWarModeTypes.NUM_FOGOFWARMODE_TYPES],
		"AnimationTypes.NONE_ANIMATION": [AnimationTypes.NONE_ANIMATION],
		"AnimationTypes.BONUSANIMATION_UNIMPROVED": [AnimationTypes.BONUSANIMATION_UNIMPROVED],
		"AnimationTypes.BONUSANIMATION_NOT_WORKED": [AnimationTypes.BONUSANIMATION_NOT_WORKED],
		"AnimationTypes.BONUSANIMATION_WORKED": [AnimationTypes.BONUSANIMATION_WORKED],
		"AnimationTypes.IMPROVEMENTANIMATION_OFF": [AnimationTypes.IMPROVEMENTANIMATION_OFF],
		"AnimationTypes.IMPROVEMENTANIMATION_ON": [AnimationTypes.IMPROVEMENTANIMATION_ON],
		"AnimationTypes.IMPROVEMENTANIMATION_OFF_EXTRA": [AnimationTypes.IMPROVEMENTANIMATION_OFF_EXTRA],
		"AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_1": [AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_1],
		"AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_2": [AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_2],
		"AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_3": [AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_3],
		"AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_4": [AnimationTypes.IMPROVEMENTANIMATION_ON_EXTRA_4],
		"EntityEventTypes.ENTITY_EVENT_NONE": [EntityEventTypes.ENTITY_EVENT_NONE],
		"AnimationPathTypes.ANIMATIONPATH_NONE": [AnimationPathTypes.ANIMATIONPATH_NONE],
		"AnimationPathTypes.ANIMATIONPATH_IDLE": [AnimationPathTypes.ANIMATIONPATH_IDLE],
		"AnimationPathTypes.ANIMATIONPATH_MOVE": [AnimationPathTypes.ANIMATIONPATH_MOVE],
		"AnimationPathTypes.ANIMATIONPATH_RANDOMIZE_ANIMATION_SET": [AnimationPathTypes.ANIMATIONPATH_RANDOMIZE_ANIMATION_SET],
		"AnimationPathTypes.ANIMATIONPATH_NUKE_STRIKE": [AnimationPathTypes.ANIMATIONPATH_NUKE_STRIKE],
		"AnimationPathTypes.ANIMATIONPATH_MELEE_STRIKE": [AnimationPathTypes.ANIMATIONPATH_MELEE_STRIKE],
		"AnimationPathTypes.ANIMATIONPATH_MELEE_HURT": [AnimationPathTypes.ANIMATIONPATH_MELEE_HURT],
		"AnimationPathTypes.ANIMATIONPATH_MELEE_DIE": [AnimationPathTypes.ANIMATIONPATH_MELEE_DIE],
		"AnimationPathTypes.ANIMATIONPATH_MELEE_FORTIFIED": [AnimationPathTypes.ANIMATIONPATH_MELEE_FORTIFIED],
		"AnimationPathTypes.ANIMATIONPATH_MELEE_DIE_FADE": [AnimationPathTypes.ANIMATIONPATH_MELEE_DIE_FADE],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_STRIKE": [AnimationPathTypes.ANIMATIONPATH_RANGED_STRIKE],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_DIE": [AnimationPathTypes.ANIMATIONPATH_RANGED_DIE],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_FORTIFIED": [AnimationPathTypes.ANIMATIONPATH_RANGED_FORTIFIED],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_RUNHIT": [AnimationPathTypes.ANIMATIONPATH_RANGED_RUNHIT],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_RUNDIE": [AnimationPathTypes.ANIMATIONPATH_RANGED_RUNDIE],
		"AnimationPathTypes.ANIMATIONPATH_RANGED_DIE_FADE": [AnimationPathTypes.ANIMATIONPATH_RANGED_DIE_FADE],
		"AnimationPathTypes.ANIMATIONPATH_LEADER_COMMAND": [AnimationPathTypes.ANIMATIONPATH_LEADER_COMMAND],
		"AnimationPathTypes.ANIMATIONPATH_AIRFADEIN": [AnimationPathTypes.ANIMATIONPATH_AIRFADEIN],
		"AnimationPathTypes.ANIMATIONPATH_AIRFADEOUT": [AnimationPathTypes.ANIMATIONPATH_AIRFADEOUT],
		"AnimationPathTypes.ANIMATIONPATH_AIRSTRIKE": [AnimationPathTypes.ANIMATIONPATH_AIRSTRIKE],
		"AnimationPathTypes.ANIMATIONPATH_AIRBOMB": [AnimationPathTypes.ANIMATIONPATH_AIRBOMB],
		"AnimationCategoryTypes.ANIMCAT_NONE": [AnimationCategoryTypes.ANIMCAT_NONE],
		"CursorTypes.NO_CURSOR": [CursorTypes.NO_CURSOR],
		"TradeableItems.NO_TRADEABLE_ITEMS": [TradeableItems.NO_TRADEABLE_ITEMS],
		"TradeableItems.TRADE_GOLD": [TradeableItems.TRADE_GOLD],
		"TradeableItems.TRADE_GOLD_PER_TURN": [TradeableItems.TRADE_GOLD_PER_TURN],
		"TradeableItems.TRADE_MAPS": [TradeableItems.TRADE_MAPS],
		"TradeableItems.TRADE_VASSAL": [TradeableItems.TRADE_VASSAL],
		"TradeableItems.TRADE_SURRENDER": [TradeableItems.TRADE_SURRENDER],
		"TradeableItems.TRADE_OPEN_BORDERS": [TradeableItems.TRADE_OPEN_BORDERS],
		"TradeableItems.TRADE_DEFENSIVE_PACT": [TradeableItems.TRADE_DEFENSIVE_PACT],
		"TradeableItems.TRADE_PERMANENT_ALLIANCE": [TradeableItems.TRADE_PERMANENT_ALLIANCE],
		"TradeableItems.TRADE_PEACE_TREATY": [TradeableItems.TRADE_PEACE_TREATY],
		"TradeableItems.NUM_BASIC_ITEMS": [TradeableItems.NUM_BASIC_ITEMS],
		"TradeableItems.TRADE_TECHNOLOGIES": [TradeableItems.TRADE_TECHNOLOGIES],
		"TradeableItems.TRADE_RESOURCES": [TradeableItems.TRADE_RESOURCES],
		"TradeableItems.TRADE_CITIES": [TradeableItems.TRADE_CITIES],
		"TradeableItems.TRADE_PEACE": [TradeableItems.TRADE_PEACE],
		"TradeableItems.TRADE_WAR": [TradeableItems.TRADE_WAR],
		"TradeableItems.TRADE_EMBARGO": [TradeableItems.TRADE_EMBARGO],
		"TradeableItems.TRADE_CIVIC": [TradeableItems.TRADE_CIVIC],
		"TradeableItems.TRADE_RELIGION": [TradeableItems.TRADE_RELIGION],
		"TradeableItems.NUM_TRADEABLE_HEADINGS": [TradeableItems.NUM_TRADEABLE_HEADINGS],
		"TradeableItems.NUM_TRADEABLE_ITEMS": [TradeableItems.NUM_TRADEABLE_ITEMS],
		"DiploEventTypes.NO_DIPLOEVENT": [DiploEventTypes.NO_DIPLOEVENT],
		"DiploEventTypes.DIPLOEVENT_CONTACT": [DiploEventTypes.DIPLOEVENT_CONTACT],
		"DiploEventTypes.DIPLOEVENT_AI_CONTACT": [DiploEventTypes.DIPLOEVENT_AI_CONTACT],
		"DiploEventTypes.DIPLOEVENT_FAILED_CONTACT": [DiploEventTypes.DIPLOEVENT_FAILED_CONTACT],
		"DiploEventTypes.DIPLOEVENT_GIVE_HELP": [DiploEventTypes.DIPLOEVENT_GIVE_HELP],
		"DiploEventTypes.DIPLOEVENT_REFUSED_HELP": [DiploEventTypes.DIPLOEVENT_REFUSED_HELP],
		"DiploEventTypes.DIPLOEVENT_ACCEPT_DEMAND": [DiploEventTypes.DIPLOEVENT_ACCEPT_DEMAND],
		"DiploEventTypes.DIPLOEVENT_REJECTED_DEMAND": [DiploEventTypes.DIPLOEVENT_REJECTED_DEMAND],
		"DiploEventTypes.DIPLOEVENT_DEMAND_WAR": [DiploEventTypes.DIPLOEVENT_DEMAND_WAR],
		"DiploEventTypes.DIPLOEVENT_CONVERT": [DiploEventTypes.DIPLOEVENT_CONVERT],
		"DiploEventTypes.DIPLOEVENT_NO_CONVERT": [DiploEventTypes.DIPLOEVENT_NO_CONVERT],
		"DiploEventTypes.DIPLOEVENT_REVOLUTION": [DiploEventTypes.DIPLOEVENT_REVOLUTION],
		"DiploEventTypes.DIPLOEVENT_NO_REVOLUTION": [DiploEventTypes.DIPLOEVENT_NO_REVOLUTION],
		"DiploEventTypes.DIPLOEVENT_JOIN_WAR": [DiploEventTypes.DIPLOEVENT_JOIN_WAR],
		"DiploEventTypes.DIPLOEVENT_NO_JOIN_WAR": [DiploEventTypes.DIPLOEVENT_NO_JOIN_WAR],
		"DiploEventTypes.DIPLOEVENT_STOP_TRADING": [DiploEventTypes.DIPLOEVENT_STOP_TRADING],
		"DiploEventTypes.DIPLOEVENT_NO_STOP_TRADING": [DiploEventTypes.DIPLOEVENT_NO_STOP_TRADING],
		"DiploEventTypes.DIPLOEVENT_ASK_HELP": [DiploEventTypes.DIPLOEVENT_ASK_HELP],
		"DiploEventTypes.DIPLOEVENT_MADE_DEMAND": [DiploEventTypes.DIPLOEVENT_MADE_DEMAND],
		"DiploEventTypes.DIPLOEVENT_RESEARCH_TECH": [DiploEventTypes.DIPLOEVENT_RESEARCH_TECH],
		"DiploEventTypes.DIPLOEVENT_TARGET_CITY": [DiploEventTypes.DIPLOEVENT_TARGET_CITY],
		"DiploEventTypes.DIPLOEVENT_MADE_DEMAND_VASSAL": [DiploEventTypes.DIPLOEVENT_MADE_DEMAND_VASSAL],
		"DiploEventTypes.NUM_DIPLOEVENT_TYPES": [DiploEventTypes.NUM_DIPLOEVENT_TYPES],
		"DiploCommentTypes.NO_DIPLOCOMMENT": [DiploCommentTypes.NO_DIPLOCOMMENT],
		"NetContactTypes.NO_NETCONTACT": [NetContactTypes.NO_NETCONTACT],
		"NetContactTypes.NETCONTACT_INITIAL": [NetContactTypes.NETCONTACT_INITIAL],
		"NetContactTypes.NETCONTACT_RESPONSE": [NetContactTypes.NETCONTACT_RESPONSE],
		"NetContactTypes.NETCONTACT_ESTABLISHED": [NetContactTypes.NETCONTACT_ESTABLISHED],
		"NetContactTypes.NETCONTACT_BUSY": [NetContactTypes.NETCONTACT_BUSY],
		"NetContactTypes.NUM_NETCONTACT_TYPES": [NetContactTypes.NUM_NETCONTACT_TYPES],
		"ContactTypes.CONTACT_RELIGION_PRESSURE": [ContactTypes.CONTACT_RELIGION_PRESSURE],
		"ContactTypes.CONTACT_CIVIC_PRESSURE": [ContactTypes.CONTACT_CIVIC_PRESSURE],
		"ContactTypes.CONTACT_JOIN_WAR": [ContactTypes.CONTACT_JOIN_WAR],
		"ContactTypes.CONTACT_STOP_TRADING": [ContactTypes.CONTACT_STOP_TRADING],
		"ContactTypes.CONTACT_GIVE_HELP": [ContactTypes.CONTACT_GIVE_HELP],
		"ContactTypes.CONTACT_ASK_FOR_HELP": [ContactTypes.CONTACT_ASK_FOR_HELP],
		"ContactTypes.CONTACT_DEMAND_TRIBUTE": [ContactTypes.CONTACT_DEMAND_TRIBUTE],
		"ContactTypes.CONTACT_OPEN_BORDERS": [ContactTypes.CONTACT_OPEN_BORDERS],
		"ContactTypes.CONTACT_DEFENSIVE_PACT": [ContactTypes.CONTACT_DEFENSIVE_PACT],
		"ContactTypes.CONTACT_PERMANENT_ALLIANCE": [ContactTypes.CONTACT_PERMANENT_ALLIANCE],
		"ContactTypes.CONTACT_PEACE_TREATY": [ContactTypes.CONTACT_PEACE_TREATY],
		"ContactTypes.CONTACT_TRADE_TECH": [ContactTypes.CONTACT_TRADE_TECH],
		"ContactTypes.CONTACT_TRADE_BONUS": [ContactTypes.CONTACT_TRADE_BONUS],
		"ContactTypes.CONTACT_TRADE_MAP": [ContactTypes.CONTACT_TRADE_MAP],
		"ContactTypes.NUM_CONTACT_TYPES": [ContactTypes.NUM_CONTACT_TYPES],
		"MemoryTypes.MEMORY_DECLARED_WAR": [MemoryTypes.MEMORY_DECLARED_WAR],
		"MemoryTypes.MEMORY_DECLARED_WAR_ON_FRIEND": [MemoryTypes.MEMORY_DECLARED_WAR_ON_FRIEND],
		"MemoryTypes.MEMORY_HIRED_WAR_ALLY": [MemoryTypes.MEMORY_HIRED_WAR_ALLY],
		"MemoryTypes.MEMORY_NUKED_US": [MemoryTypes.MEMORY_NUKED_US],
		"MemoryTypes.MEMORY_NUKED_FRIEND": [MemoryTypes.MEMORY_NUKED_FRIEND],
		"MemoryTypes.MEMORY_RAZED_CITY": [MemoryTypes.MEMORY_RAZED_CITY],
		"MemoryTypes.MEMORY_RAZED_HOLY_CITY": [MemoryTypes.MEMORY_RAZED_HOLY_CITY],
		"MemoryTypes.MEMORY_SPY_CAUGHT": [MemoryTypes.MEMORY_SPY_CAUGHT],
		"MemoryTypes.MEMORY_GIVE_HELP": [MemoryTypes.MEMORY_GIVE_HELP],
		"MemoryTypes.MEMORY_REFUSED_HELP": [MemoryTypes.MEMORY_REFUSED_HELP],
		"MemoryTypes.MEMORY_ACCEPT_DEMAND": [MemoryTypes.MEMORY_ACCEPT_DEMAND],
		"MemoryTypes.MEMORY_REJECTED_DEMAND": [MemoryTypes.MEMORY_REJECTED_DEMAND],
		"MemoryTypes.MEMORY_ACCEPTED_RELIGION": [MemoryTypes.MEMORY_ACCEPTED_RELIGION],
		"MemoryTypes.MEMORY_DENIED_RELIGION": [MemoryTypes.MEMORY_DENIED_RELIGION],
		"MemoryTypes.MEMORY_ACCEPTED_CIVIC": [MemoryTypes.MEMORY_ACCEPTED_CIVIC],
		"MemoryTypes.MEMORY_DENIED_CIVIC": [MemoryTypes.MEMORY_DENIED_CIVIC],
		"MemoryTypes.MEMORY_ACCEPTED_JOIN_WAR": [MemoryTypes.MEMORY_ACCEPTED_JOIN_WAR],
		"MemoryTypes.MEMORY_DENIED_JOIN_WAR": [MemoryTypes.MEMORY_DENIED_JOIN_WAR],
		"MemoryTypes.MEMORY_ACCEPTED_STOP_TRADING": [MemoryTypes.MEMORY_ACCEPTED_STOP_TRADING],
		"MemoryTypes.MEMORY_DENIED_STOP_TRADING": [MemoryTypes.MEMORY_DENIED_STOP_TRADING],
		"MemoryTypes.MEMORY_STOPPED_TRADING": [MemoryTypes.MEMORY_STOPPED_TRADING],
		"MemoryTypes.MEMORY_STOPPED_TRADING_RECENT": [MemoryTypes.MEMORY_STOPPED_TRADING_RECENT],
		"MemoryTypes.MEMORY_HIRED_TRADE_EMBARGO": [MemoryTypes.MEMORY_HIRED_TRADE_EMBARGO],
		"MemoryTypes.MEMORY_MADE_DEMAND": [MemoryTypes.MEMORY_MADE_DEMAND],
		"MemoryTypes.MEMORY_MADE_DEMAND_RECENT": [MemoryTypes.MEMORY_MADE_DEMAND_RECENT],
		"MemoryTypes.MEMORY_CANCELLED_OPEN_BORDERS": [MemoryTypes.MEMORY_CANCELLED_OPEN_BORDERS],
		"MemoryTypes.MEMORY_TRADED_TECH_TO_US": [MemoryTypes.MEMORY_TRADED_TECH_TO_US],
		"MemoryTypes.MEMORY_RECEIVED_TECH_FROM_ANY": [MemoryTypes.MEMORY_RECEIVED_TECH_FROM_ANY],
		"MemoryTypes.MEMORY_VOTED_AGAINST_US": [MemoryTypes.MEMORY_VOTED_AGAINST_US],
		"MemoryTypes.MEMORY_VOTED_FOR_US": [MemoryTypes.MEMORY_VOTED_FOR_US],
		"MemoryTypes.MEMORY_EVENT_GOOD_TO_US": [MemoryTypes.MEMORY_EVENT_GOOD_TO_US],
		"MemoryTypes.MEMORY_EVENT_BAD_TO_US": [MemoryTypes.MEMORY_EVENT_BAD_TO_US],
		"MemoryTypes.MEMORY_LIBERATED_CITIES": [MemoryTypes.MEMORY_LIBERATED_CITIES],
		"MemoryTypes.NUM_MEMORY_TYPES": [MemoryTypes.NUM_MEMORY_TYPES],
		"AttitudeTypes.NO_ATTITUDE": [AttitudeTypes.NO_ATTITUDE],
		"AttitudeTypes.ATTITUDE_FURIOUS": [AttitudeTypes.ATTITUDE_FURIOUS],
		"AttitudeTypes.ATTITUDE_ANNOYED": [AttitudeTypes.ATTITUDE_ANNOYED],
		"AttitudeTypes.ATTITUDE_CAUTIOUS": [AttitudeTypes.ATTITUDE_CAUTIOUS],
		"AttitudeTypes.ATTITUDE_PLEASED": [AttitudeTypes.ATTITUDE_PLEASED],
		"AttitudeTypes.ATTITUDE_FRIENDLY": [AttitudeTypes.ATTITUDE_FRIENDLY],
		"AttitudeTypes.NUM_ATTITUDE_TYPES": [AttitudeTypes.NUM_ATTITUDE_TYPES],
		"LeaderheadAction.NO_LEADERANIM": [LeaderheadAction.NO_LEADERANIM],
		"LeaderheadAction.LEADERANIM_GREETING": [LeaderheadAction.LEADERANIM_GREETING],
		"LeaderheadAction.LEADERANIM_FRIENDLY": [LeaderheadAction.LEADERANIM_FRIENDLY],
		"LeaderheadAction.LEADERANIM_PLEASED": [LeaderheadAction.LEADERANIM_PLEASED],
		"LeaderheadAction.LEADERANIM_CAUTIOUS": [LeaderheadAction.LEADERANIM_CAUTIOUS],
		"LeaderheadAction.LEADERANIM_ANNOYED": [LeaderheadAction.LEADERANIM_ANNOYED],
		"LeaderheadAction.LEADERANIM_FURIOUS": [LeaderheadAction.LEADERANIM_FURIOUS],
		"LeaderheadAction.LEADERANIM_DISAGREE": [LeaderheadAction.LEADERANIM_DISAGREE],
		"LeaderheadAction.LEADERANIM_AGREE": [LeaderheadAction.LEADERANIM_AGREE],
		"LeaderheadAction.NUM_LEADERANIM_TYPES": [LeaderheadAction.NUM_LEADERANIM_TYPES],
		"DiplomacyPowerTypes.NO_DIPLOMACYPOWER": [DiplomacyPowerTypes.NO_DIPLOMACYPOWER],
		"DiplomacyPowerTypes.DIPLOMACYPOWER_WEAKER": [DiplomacyPowerTypes.DIPLOMACYPOWER_WEAKER],
		"DiplomacyPowerTypes.DIPLOMACYPOWER_EQUAL": [DiplomacyPowerTypes.DIPLOMACYPOWER_EQUAL],
		"DiplomacyPowerTypes.DIPLOMACYPOWER_STRONGER": [DiplomacyPowerTypes.DIPLOMACYPOWER_STRONGER],
		"DiplomacyPowerTypes.NUM_DIPLOMACYPOWER_TYPES": [DiplomacyPowerTypes.NUM_DIPLOMACYPOWER_TYPES],
		"FeatTypes.FEAT_UNITCOMBAT_ARCHER": [FeatTypes.FEAT_UNITCOMBAT_ARCHER],
		"FeatTypes.FEAT_UNITCOMBAT_MOUNTED": [FeatTypes.FEAT_UNITCOMBAT_MOUNTED],
		"FeatTypes.FEAT_UNITCOMBAT_MELEE": [FeatTypes.FEAT_UNITCOMBAT_MELEE],
		"FeatTypes.FEAT_UNITCOMBAT_SIEGE": [FeatTypes.FEAT_UNITCOMBAT_SIEGE],
		"FeatTypes.FEAT_UNITCOMBAT_GUN": [FeatTypes.FEAT_UNITCOMBAT_GUN],
		"FeatTypes.FEAT_UNITCOMBAT_ARMOR": [FeatTypes.FEAT_UNITCOMBAT_ARMOR],
		"FeatTypes.FEAT_UNITCOMBAT_HELICOPTER": [FeatTypes.FEAT_UNITCOMBAT_HELICOPTER],
		"FeatTypes.FEAT_UNITCOMBAT_NAVAL": [FeatTypes.FEAT_UNITCOMBAT_NAVAL],
		"FeatTypes.FEAT_UNIT_PRIVATEER": [FeatTypes.FEAT_UNIT_PRIVATEER],
		"FeatTypes.FEAT_UNIT_SPY": [FeatTypes.FEAT_UNIT_SPY],
		"FeatTypes.FEAT_NATIONAL_WONDER": [FeatTypes.FEAT_NATIONAL_WONDER],
		"FeatTypes.FEAT_TRADE_ROUTE": [FeatTypes.FEAT_TRADE_ROUTE],
		"FeatTypes.FEAT_COPPER_CONNECTED": [FeatTypes.FEAT_COPPER_CONNECTED],
		"FeatTypes.FEAT_HORSE_CONNECTED": [FeatTypes.FEAT_HORSE_CONNECTED],
		"FeatTypes.FEAT_IRON_CONNECTED": [FeatTypes.FEAT_IRON_CONNECTED],
		"FeatTypes.FEAT_LUXURY_CONNECTED": [FeatTypes.FEAT_LUXURY_CONNECTED],
		"FeatTypes.FEAT_FOOD_CONNECTED": [FeatTypes.FEAT_FOOD_CONNECTED],
		"FeatTypes.FEAT_POPULATION_1K": [FeatTypes.FEAT_POPULATION_1K],
		"FeatTypes.FEAT_POPULATION_5K": [FeatTypes.FEAT_POPULATION_5K],
		"FeatTypes.FEAT_POPULATION_10K": [FeatTypes.FEAT_POPULATION_10K],
		"FeatTypes.FEAT_POPULATION_25K": [FeatTypes.FEAT_POPULATION_25K],
		"FeatTypes.FEAT_POPULATION_50K": [FeatTypes.FEAT_POPULATION_50K],
		"FeatTypes.FEAT_POPULATION_100K": [FeatTypes.FEAT_POPULATION_100K],
		"FeatTypes.FEAT_POPULATION_250K": [FeatTypes.FEAT_POPULATION_250K],
		"FeatTypes.FEAT_POPULATION_HALF_MILLION": [FeatTypes.FEAT_POPULATION_HALF_MILLION],
		"FeatTypes.FEAT_POPULATION_1_MILLION": [FeatTypes.FEAT_POPULATION_1_MILLION],
		"FeatTypes.FEAT_POPULATION_2_MILLION": [FeatTypes.FEAT_POPULATION_2_MILLION],
		"FeatTypes.FEAT_POPULATION_5_MILLION": [FeatTypes.FEAT_POPULATION_5_MILLION],
		"FeatTypes.FEAT_POPULATION_10_MILLION": [FeatTypes.FEAT_POPULATION_10_MILLION],
		"FeatTypes.FEAT_POPULATION_20_MILLION": [FeatTypes.FEAT_POPULATION_20_MILLION],
		"FeatTypes.FEAT_POPULATION_50_MILLION": [FeatTypes.FEAT_POPULATION_50_MILLION],
		"FeatTypes.FEAT_POPULATION_100_MILLION": [FeatTypes.FEAT_POPULATION_100_MILLION],
		"FeatTypes.FEAT_POPULATION_200_MILLION": [FeatTypes.FEAT_POPULATION_200_MILLION],
		"FeatTypes.FEAT_POPULATION_500_MILLION": [FeatTypes.FEAT_POPULATION_500_MILLION],
		"FeatTypes.FEAT_POPULATION_1_BILLION": [FeatTypes.FEAT_POPULATION_1_BILLION],
		"FeatTypes.FEAT_POPULATION_2_BILLION": [FeatTypes.FEAT_POPULATION_2_BILLION],
		"FeatTypes.FEAT_CORPORATION_ENABLED": [FeatTypes.FEAT_CORPORATION_ENABLED],
		"FeatTypes.FEAT_PAD": [FeatTypes.FEAT_PAD],
		"FeatTypes.NUM_FEAT_TYPES": [FeatTypes.NUM_FEAT_TYPES],
		"SaveGameTypes.SAVEGAME_NONE": [SaveGameTypes.SAVEGAME_NONE],
		"SaveGameTypes.SAVEGAME_AUTO": [SaveGameTypes.SAVEGAME_AUTO],
		"SaveGameTypes.SAVEGAME_RECOVERY": [SaveGameTypes.SAVEGAME_RECOVERY],
		"SaveGameTypes.SAVEGAME_QUICK": [SaveGameTypes.SAVEGAME_QUICK],
		"SaveGameTypes.SAVEGAME_NORMAL": [SaveGameTypes.SAVEGAME_NORMAL],
		"SaveGameTypes.SAVEGAME_GROUP": [SaveGameTypes.SAVEGAME_GROUP],
		"SaveGameTypes.SAVEGAME_DROP_QUIT": [SaveGameTypes.SAVEGAME_DROP_QUIT],
		"SaveGameTypes.SAVEGAME_DROP_CONTINUE": [SaveGameTypes.SAVEGAME_DROP_CONTINUE],
		"SaveGameTypes.SAVEGAME_PBEM": [SaveGameTypes.SAVEGAME_PBEM],
		"SaveGameTypes.SAVEGAME_REPLAY": [SaveGameTypes.SAVEGAME_REPLAY],
		"SaveGameTypes.NUM_SAVEGAME_TYPES": [SaveGameTypes.NUM_SAVEGAME_TYPES],
		"GameType.GAME_NONE": [GameType.GAME_NONE],
		"GameType.GAME_SP_NEW": [GameType.GAME_SP_NEW],
		"GameType.GAME_SP_SCENARIO": [GameType.GAME_SP_SCENARIO],
		"GameType.GAME_SP_LOAD": [GameType.GAME_SP_LOAD],
		"GameType.GAME_MP_NEW": [GameType.GAME_MP_NEW],
		"GameType.GAME_MP_SCENARIO": [GameType.GAME_MP_SCENARIO],
		"GameType.GAME_MP_LOAD": [GameType.GAME_MP_LOAD],
		"GameType.GAME_HOTSEAT_NEW": [GameType.GAME_HOTSEAT_NEW],
		"GameType.GAME_HOTSEAT_SCENARIO": [GameType.GAME_HOTSEAT_SCENARIO],
		"GameType.GAME_HOTSEAT_LOAD": [GameType.GAME_HOTSEAT_LOAD],
		"GameType.GAME_PBEM_NEW": [GameType.GAME_PBEM_NEW],
		"GameType.GAME_PBEM_SCENARIO": [GameType.GAME_PBEM_SCENARIO],
		"GameType.GAME_PBEM_LOAD": [GameType.GAME_PBEM_LOAD],
		"GameType.GAME_REPLAY": [GameType.GAME_REPLAY],
		"GameType.NUM_GAMETYPES": [GameType.NUM_GAMETYPES],
		"GameMode.NO_GAMEMODE": [GameMode.NO_GAMEMODE],
		"GameMode.GAMEMODE_NORMAL": [GameMode.GAMEMODE_NORMAL],
		"GameMode.GAMEMODE_PITBOSS": [GameMode.GAMEMODE_PITBOSS],
		"GameMode.NUM_GAMEMODES": [GameMode.NUM_GAMEMODES],
		"InterfaceVisibility.INTERFACE_SHOW": [InterfaceVisibility.INTERFACE_SHOW],
		"InterfaceVisibility.INTERFACE_HIDE": [InterfaceVisibility.INTERFACE_HIDE],
		"InterfaceVisibility.INTERFACE_HIDE_ALL": [InterfaceVisibility.INTERFACE_HIDE_ALL],
		"InterfaceVisibility.INTERFACE_MINIMAP_ONLY": [InterfaceVisibility.INTERFACE_MINIMAP_ONLY],
		"InterfaceVisibility.INTERFACE_ADVANCED_START": [InterfaceVisibility.INTERFACE_ADVANCED_START],
		"GenericButtonSizes.BUTTON_SIZE_46": [GenericButtonSizes.BUTTON_SIZE_46],
		"GenericButtonSizes.BUTTON_SIZE_32": [GenericButtonSizes.BUTTON_SIZE_32],
		"GenericButtonSizes.BUTTON_SIZE_24": [GenericButtonSizes.BUTTON_SIZE_24],
		"GenericButtonSizes.BUTTON_SIZE_16": [GenericButtonSizes.BUTTON_SIZE_16],
		"GenericButtonSizes.BUTTON_SIZE_CUSTOM": [GenericButtonSizes.BUTTON_SIZE_CUSTOM],
		"WorldBuilderPopupTypes.WBPOPUP_NONE": [WorldBuilderPopupTypes.WBPOPUP_NONE],
		"WorldBuilderPopupTypes.WBPOPUP_START": [WorldBuilderPopupTypes.WBPOPUP_START],
		"WorldBuilderPopupTypes.WBPOPUP_CITY": [WorldBuilderPopupTypes.WBPOPUP_CITY],
		"WorldBuilderPopupTypes.WBPOPUP_UNIT": [WorldBuilderPopupTypes.WBPOPUP_UNIT],
		"WorldBuilderPopupTypes.WBPOPUP_PLAYER": [WorldBuilderPopupTypes.WBPOPUP_PLAYER],
		"WorldBuilderPopupTypes.WBPOPUP_PLOT": [WorldBuilderPopupTypes.WBPOPUP_PLOT],
		"WorldBuilderPopupTypes.WBPOPUP_TERRAIN": [WorldBuilderPopupTypes.WBPOPUP_TERRAIN],
		"WorldBuilderPopupTypes.WBPOPUP_FEATURE": [WorldBuilderPopupTypes.WBPOPUP_FEATURE],
		"WorldBuilderPopupTypes.WBPOPUP_IMPROVEMENT": [WorldBuilderPopupTypes.WBPOPUP_IMPROVEMENT],
		"WorldBuilderPopupTypes.WBPOPUP_GAME": [WorldBuilderPopupTypes.WBPOPUP_GAME],
		"WorldBuilderPopupTypes.NUM_WBPOPUP": [WorldBuilderPopupTypes.NUM_WBPOPUP],
		"EventType.EVT_LBUTTONDOWN": [EventType.EVT_LBUTTONDOWN],
		"EventType.EVT_LBUTTONDBLCLICK": [EventType.EVT_LBUTTONDBLCLICK],
		"EventType.EVT_RBUTTONDOWN": [EventType.EVT_RBUTTONDOWN],
		"EventType.EVT_BACK": [EventType.EVT_BACK],
		"EventType.EVT_FORWARD": [EventType.EVT_FORWARD],
		"EventType.EVT_KEYDOWN": [EventType.EVT_KEYDOWN],
		"EventType.EVT_KEYUP": [EventType.EVT_KEYUP],
		"LoadType.LOAD_NORMAL": [LoadType.LOAD_NORMAL],
		"LoadType.LOAD_INIT": [LoadType.LOAD_INIT],
		"LoadType.LOAD_SETUP": [LoadType.LOAD_SETUP],
		"LoadType.LOAD_GAMETYPE": [LoadType.LOAD_GAMETYPE],
		"LoadType.LOAD_REPLAY": [LoadType.LOAD_REPLAY],
		"FontTypes.TITLE_FONT": [FontTypes.TITLE_FONT],
		"FontTypes.GAME_FONT": [FontTypes.GAME_FONT],
		"FontTypes.SMALL_FONT": [FontTypes.SMALL_FONT],
		"FontTypes.MENU_FONT": [FontTypes.MENU_FONT],
		"FontTypes.MENU_HIGHLIGHT_FONT": [FontTypes.MENU_HIGHLIGHT_FONT],
		"PanelStyles.PANEL_STYLE_STANDARD": [PanelStyles.PANEL_STYLE_STANDARD],
		"PanelStyles.PANEL_STYLE_SOLID": [PanelStyles.PANEL_STYLE_SOLID],
		"PanelStyles.PANEL_STYLE_EMPTY": [PanelStyles.PANEL_STYLE_EMPTY],
		"PanelStyles.PANEL_STYLE_FLAT": [PanelStyles.PANEL_STYLE_FLAT],
		"PanelStyles.PANEL_STYLE_IN": [PanelStyles.PANEL_STYLE_IN],
		"PanelStyles.PANEL_STYLE_OUT": [PanelStyles.PANEL_STYLE_OUT],
		"PanelStyles.PANEL_STYLE_EXTERNAL": [PanelStyles.PANEL_STYLE_EXTERNAL],
		"PanelStyles.PANEL_STYLE_DEFAULT": [PanelStyles.PANEL_STYLE_DEFAULT],
		"PanelStyles.PANEL_STYLE_CIVILPEDIA": [PanelStyles.PANEL_STYLE_CIVILPEDIA],
		"PanelStyles.PANEL_STYLE_STONE": [PanelStyles.PANEL_STYLE_STONE],
		"PanelStyles.PANEL_STYLE_BLUELARGE": [PanelStyles.PANEL_STYLE_BLUELARGE],
		"PanelStyles.PANEL_STYLE_UNITSTAT": [PanelStyles.PANEL_STYLE_UNITSTAT],
		"PanelStyles.PANEL_STYLE_BLUE50": [PanelStyles.PANEL_STYLE_BLUE50],
		"PanelStyles.PANEL_STYLE_TOPBAR": [PanelStyles.PANEL_STYLE_TOPBAR],
		"PanelStyles.PANEL_STYLE_BOTTOMBAR": [PanelStyles.PANEL_STYLE_BOTTOMBAR],
		"PanelStyles.PANEL_STYLE_TECH": [PanelStyles.PANEL_STYLE_TECH],
		"PanelStyles.PANEL_STYLE_GAMEHUD_LEFT": [PanelStyles.PANEL_STYLE_GAMEHUD_LEFT],
		"PanelStyles.PANEL_STYLE_GAMEHUD_RIGHT": [PanelStyles.PANEL_STYLE_GAMEHUD_RIGHT],
		"PanelStyles.PANEL_STYLE_GAMEHUD_CENTER": [PanelStyles.PANEL_STYLE_GAMEHUD_CENTER],
		"PanelStyles.PANEL_STYLE_GAMEHUD_STATS": [PanelStyles.PANEL_STYLE_GAMEHUD_STATS],
		"PanelStyles.PANEL_STYLE_GAME_MAP": [PanelStyles.PANEL_STYLE_GAME_MAP],
		"PanelStyles.PANEL_STYLE_GAME_TOPBAR": [PanelStyles.PANEL_STYLE_GAME_TOPBAR],
		"PanelStyles.PANEL_STYLE_HUD_HELP": [PanelStyles.PANEL_STYLE_HUD_HELP],
		"PanelStyles.PANEL_STYLE_CITY_LEFT": [PanelStyles.PANEL_STYLE_CITY_LEFT],
		"PanelStyles.PANEL_STYLE_CITY_RIGHT": [PanelStyles.PANEL_STYLE_CITY_RIGHT],
		"PanelStyles.PANEL_STYLE_CITY_TOP": [PanelStyles.PANEL_STYLE_CITY_TOP],
		"PanelStyles.PANEL_STYLE_CITY_TANSHADE": [PanelStyles.PANEL_STYLE_CITY_TANSHADE],
		"PanelStyles.PANEL_STYLE_CITY_INFO": [PanelStyles.PANEL_STYLE_CITY_INFO],
		"PanelStyles.PANEL_STYLE_CITY_TANTL": [PanelStyles.PANEL_STYLE_CITY_TANTL],
		"PanelStyles.PANEL_STYLE_CITY_TANTR": [PanelStyles.PANEL_STYLE_CITY_TANTR],
		"PanelStyles.PANEL_STYLE_CITY_COLUMNL": [PanelStyles.PANEL_STYLE_CITY_COLUMNL],
		"PanelStyles.PANEL_STYLE_CITY_COLUMNC": [PanelStyles.PANEL_STYLE_CITY_COLUMNC],
		"PanelStyles.PANEL_STYLE_CITY_COLUMNR": [PanelStyles.PANEL_STYLE_CITY_COLUMNR],
		"PanelStyles.PANEL_STYLE_CITY_TITLE": [PanelStyles.PANEL_STYLE_CITY_TITLE],
		"PanelStyles.PANEL_STYLE_DAWN": [PanelStyles.PANEL_STYLE_DAWN],
		"PanelStyles.PANEL_STYLE_DAWNTOP": [PanelStyles.PANEL_STYLE_DAWNTOP],
		"PanelStyles.PANEL_STYLE_DAWNBOTTOM": [PanelStyles.PANEL_STYLE_DAWNBOTTOM],
		"PanelStyles.PANEL_STYLE_MAIN": [PanelStyles.PANEL_STYLE_MAIN],
		"PanelStyles.PANEL_STYLE_MAIN_BLACK25": [PanelStyles.PANEL_STYLE_MAIN_BLACK25],
		"PanelStyles.PANEL_STYLE_MAIN_BLACK50": [PanelStyles.PANEL_STYLE_MAIN_BLACK50],
		"PanelStyles.PANEL_STYLE_MAIN_WHITE": [PanelStyles.PANEL_STYLE_MAIN_WHITE],
		"PanelStyles.PANEL_STYLE_MAIN_WHITETAB": [PanelStyles.PANEL_STYLE_MAIN_WHITETAB],
		"PanelStyles.PANEL_STYLE_MAIN_TAN": [PanelStyles.PANEL_STYLE_MAIN_TAN],
		"PanelStyles.PANEL_STYLE_MAIN_TAN15": [PanelStyles.PANEL_STYLE_MAIN_TAN15],
		"PanelStyles.PANEL_STYLE_MAIN_TANL": [PanelStyles.PANEL_STYLE_MAIN_TANL],
		"PanelStyles.PANEL_STYLE_MAIN_TANR": [PanelStyles.PANEL_STYLE_MAIN_TANR],
		"PanelStyles.PANEL_STYLE_MAIN_TANT": [PanelStyles.PANEL_STYLE_MAIN_TANT],
		"PanelStyles.PANEL_STYLE_MAIN_TANB": [PanelStyles.PANEL_STYLE_MAIN_TANB],
		"PanelStyles.PANEL_STYLE_MAIN_BOTTOMBAR": [PanelStyles.PANEL_STYLE_MAIN_BOTTOMBAR],
		"PanelStyles.PANEL_STYLE_MAIN_SELECT": [PanelStyles.PANEL_STYLE_MAIN_SELECT],
		"ButtonStyles.BUTTON_STYLE_STANDARD": [ButtonStyles.BUTTON_STYLE_STANDARD],
		"ButtonStyles.BUTTON_STYLE_ETCHED": [ButtonStyles.BUTTON_STYLE_ETCHED],
		"ButtonStyles.BUTTON_STYLE_FLAT": [ButtonStyles.BUTTON_STYLE_FLAT],
		"ButtonStyles.BUTTON_STYLE_IMAGE": [ButtonStyles.BUTTON_STYLE_IMAGE],
		"ButtonStyles.BUTTON_STYLE_LABEL": [ButtonStyles.BUTTON_STYLE_LABEL],
		"ButtonStyles.BUTTON_STYLE_LINK": [ButtonStyles.BUTTON_STYLE_LINK],
		"ButtonStyles.BUTTON_STYLE_SQUARE": [ButtonStyles.BUTTON_STYLE_SQUARE],
		"ButtonStyles.BUTTON_STYLE_TOOL": [ButtonStyles.BUTTON_STYLE_TOOL],
		"ButtonStyles.BUTTON_STYLE_DEFAULT": [ButtonStyles.BUTTON_STYLE_DEFAULT],
		"ButtonStyles.BUTTON_STYLE_CIRCLE": [ButtonStyles.BUTTON_STYLE_CIRCLE],
		"ButtonStyles.BUTTON_STYLE_CITY_B01": [ButtonStyles.BUTTON_STYLE_CITY_B01],
		"ButtonStyles.BUTTON_STYLE_CITY_B02TL": [ButtonStyles.BUTTON_STYLE_CITY_B02TL],
		"ButtonStyles.BUTTON_STYLE_CITY_B02TR": [ButtonStyles.BUTTON_STYLE_CITY_B02TR],
		"ButtonStyles.BUTTON_STYLE_CITY_B02BL": [ButtonStyles.BUTTON_STYLE_CITY_B02BL],
		"ButtonStyles.BUTTON_STYLE_CITY_B02BR": [ButtonStyles.BUTTON_STYLE_CITY_B02BR],
		"ButtonStyles.BUTTON_STYLE_CITY_B03TL": [ButtonStyles.BUTTON_STYLE_CITY_B03TL],
		"ButtonStyles.BUTTON_STYLE_CITY_B03TC": [ButtonStyles.BUTTON_STYLE_CITY_B03TC],
		"ButtonStyles.BUTTON_STYLE_CITY_B03TR": [ButtonStyles.BUTTON_STYLE_CITY_B03TR],
		"ButtonStyles.BUTTON_STYLE_CITY_B03BL": [ButtonStyles.BUTTON_STYLE_CITY_B03BL],
		"ButtonStyles.BUTTON_STYLE_CITY_B03BC": [ButtonStyles.BUTTON_STYLE_CITY_B03BC],
		"ButtonStyles.BUTTON_STYLE_CITY_B03BR": [ButtonStyles.BUTTON_STYLE_CITY_B03BR],
		"ButtonStyles.BUTTON_STYLE_CITY_FLAT": [ButtonStyles.BUTTON_STYLE_CITY_FLAT],
		"ButtonStyles.BUTTON_STYLE_CITY_PLUS": [ButtonStyles.BUTTON_STYLE_CITY_PLUS],
		"ButtonStyles.BUTTON_STYLE_CITY_MINUS": [ButtonStyles.BUTTON_STYLE_CITY_MINUS],
		"ButtonStyles.BUTTON_STYLE_ARROW_LEFT": [ButtonStyles.BUTTON_STYLE_ARROW_LEFT],
		"ButtonStyles.BUTTON_STYLE_ARROW_RIGHT": [ButtonStyles.BUTTON_STYLE_ARROW_RIGHT],
		"TableStyles.TABLE_STYLE_STANDARD": [TableStyles.TABLE_STYLE_STANDARD],
		"TableStyles.TABLE_STYLE_EMPTY": [TableStyles.TABLE_STYLE_EMPTY],
		"TableStyles.TABLE_STYLE_ALTEMPTY": [TableStyles.TABLE_STYLE_ALTEMPTY],
		"TableStyles.TABLE_STYLE_CITY": [TableStyles.TABLE_STYLE_CITY],
		"TableStyles.TABLE_STYLE_EMPTYSELECTINACTIVE": [TableStyles.TABLE_STYLE_EMPTYSELECTINACTIVE],
		"TableStyles.TABLE_STYLE_ALTDEFAULT": [TableStyles.TABLE_STYLE_ALTDEFAULT],
		"TableStyles.TABLE_STYLE_STAGINGROOM": [TableStyles.TABLE_STYLE_STAGINGROOM],
		"EventContextTypes.NO_EVENTCONTEXT": [EventContextTypes.NO_EVENTCONTEXT],
		"EventContextTypes.EVENTCONTEXT_SELF": [EventContextTypes.EVENTCONTEXT_SELF],
		"EventContextTypes.EVENTCONTEXT_ALL": [EventContextTypes.EVENTCONTEXT_ALL],
		"TabGroupTypes.NO_TABGROUP": [TabGroupTypes.NO_TABGROUP],
		"TabGroupTypes.TABGROUP_GAME": [TabGroupTypes.TABGROUP_GAME],
		"TabGroupTypes.TABGROUP_INPUT": [TabGroupTypes.TABGROUP_INPUT],
		"TabGroupTypes.TABGROUP_GRAPHICS": [TabGroupTypes.TABGROUP_GRAPHICS],
		"TabGroupTypes.TABGROUP_AUDIO": [TabGroupTypes.TABGROUP_AUDIO],
		"TabGroupTypes.TABGROUP_CLOCK": [TabGroupTypes.TABGROUP_CLOCK],
		"TabGroupTypes.NUM_TABGROUPS": [TabGroupTypes.NUM_TABGROUPS],
		"ReplayMessageTypes.NO_REPLAY_MESSAGE": [ReplayMessageTypes.NO_REPLAY_MESSAGE],
		"ReplayMessageTypes.REPLAY_MESSAGE_MAJOR_EVENT": [ReplayMessageTypes.REPLAY_MESSAGE_MAJOR_EVENT],
		"ReplayMessageTypes.REPLAY_MESSAGE_CITY_FOUNDED": [ReplayMessageTypes.REPLAY_MESSAGE_CITY_FOUNDED],
		"ReplayMessageTypes.REPLAY_MESSAGE_PLOT_OWNER_CHANGE": [ReplayMessageTypes.REPLAY_MESSAGE_PLOT_OWNER_CHANGE],
		"ReplayMessageTypes.NUM_REPLAY_MESSAGE_TYPES": [ReplayMessageTypes.NUM_REPLAY_MESSAGE_TYPES],
		"AudioTag.AUDIOTAG_NONE": [AudioTag.AUDIOTAG_NONE],
		"AudioTag.AUDIOTAG_SOUNDID": [AudioTag.AUDIOTAG_SOUNDID],
		"AudioTag.AUDIOTAG_CONTEXTID": [AudioTag.AUDIOTAG_CONTEXTID],
		"AudioTag.AUDIOTAG_SOUNDTYPE": [AudioTag.AUDIOTAG_SOUNDTYPE],
		"AudioTag.AUDIOTAG_2DSCRIPT": [AudioTag.AUDIOTAG_2DSCRIPT],
		"AudioTag.AUDIOTAG_3DSCRIPT": [AudioTag.AUDIOTAG_3DSCRIPT],
		"AudioTag.AUDIOTAG_SOUNDSCAPE": [AudioTag.AUDIOTAG_SOUNDSCAPE],
		"AudioTag.AUDIOTAG_POSITION": [AudioTag.AUDIOTAG_POSITION],
		"AudioTag.AUDIOTAG_SCRIPTTYPE": [AudioTag.AUDIOTAG_SCRIPTTYPE],
		"AudioTag.AUDIOTAG_LOADTYPE": [AudioTag.AUDIOTAG_LOADTYPE],
		"AudioTag.AUDIOTAG_COUNT": [AudioTag.AUDIOTAG_COUNT],
		"CivilopediaPageTypes.NO_CIVILOPEDIA_PAGE": [CivilopediaPageTypes.NO_CIVILOPEDIA_PAGE],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_TECH": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_TECH],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_UNIT": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_UNIT],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_BUILDING": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_BUILDING],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_WONDER": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_WONDER],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_BONUS": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_BONUS],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_IMPROVEMENT": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_IMPROVEMENT],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_PROMOTION": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_PROMOTION],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_UNIT_GROUP": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_UNIT_GROUP],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_CIV": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_CIV],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_LEADER": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_LEADER],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_RELIGION": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_RELIGION],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_CORPORATION": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_CORPORATION],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_CIVIC": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_CIVIC],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_PROJECT": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_PROJECT],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_CONCEPT": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_CONCEPT],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_CONCEPT_NEW": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_CONCEPT_NEW],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_SPECIALIST": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_SPECIALIST],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_TERRAIN": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_TERRAIN],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_FEATURE": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_FEATURE],
		"CivilopediaPageTypes.CIVILOPEDIA_PAGE_HINTS": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_HINTS],
		"CivilopediaPageTypes.NUM_CIVILOPEDIA_PAGE_TYPES": [CivilopediaPageTypes.NUM_CIVILOPEDIA_PAGE_TYPES],
		"ActionSubTypes.NO_ACTIONSUBTYPE": [ActionSubTypes.NO_ACTIONSUBTYPE],
		"ActionSubTypes.ACTIONSUBTYPE_INTERFACEMODE": [ActionSubTypes.ACTIONSUBTYPE_INTERFACEMODE],
		"ActionSubTypes.ACTIONSUBTYPE_COMMAND": [ActionSubTypes.ACTIONSUBTYPE_COMMAND],
		"ActionSubTypes.ACTIONSUBTYPE_BUILD": [ActionSubTypes.ACTIONSUBTYPE_BUILD],
		"ActionSubTypes.ACTIONSUBTYPE_PROMOTION": [ActionSubTypes.ACTIONSUBTYPE_PROMOTION],
		"ActionSubTypes.ACTIONSUBTYPE_UNIT": [ActionSubTypes.ACTIONSUBTYPE_UNIT],
		"ActionSubTypes.ACTIONSUBTYPE_RELIGION": [ActionSubTypes.ACTIONSUBTYPE_RELIGION],
		"ActionSubTypes.ACTIONSUBTYPE_SPECIALIST": [ActionSubTypes.ACTIONSUBTYPE_SPECIALIST],
		"ActionSubTypes.ACTIONSUBTYPE_BUILDING": [ActionSubTypes.ACTIONSUBTYPE_BUILDING],
		"ActionSubTypes.ACTIONSUBTYPE_CONTROL": [ActionSubTypes.ACTIONSUBTYPE_CONTROL],
		"ActionSubTypes.ACTIONSUBTYPE_AUTOMATE": [ActionSubTypes.ACTIONSUBTYPE_AUTOMATE],
		"ActionSubTypes.ACTIONSUBTYPE_MISSION": [ActionSubTypes.ACTIONSUBTYPE_MISSION],
		"ActionSubTypes.NUM_ACTIONSUBTYPES": [ActionSubTypes.NUM_ACTIONSUBTYPES],
		"GameMessageTypes.GAMEMESSAGE_NETWORK_READY": [GameMessageTypes.GAMEMESSAGE_NETWORK_READY],
		"GameMessageTypes.GAMEMESSAGE_SAVE_GAME_FLAG": [GameMessageTypes.GAMEMESSAGE_SAVE_GAME_FLAG],
		"GameMessageTypes.GAMEMESSAGE_SAVE_FLAG_ACK": [GameMessageTypes.GAMEMESSAGE_SAVE_FLAG_ACK],
		"GameMessageTypes.GAMEMESSAGE_VERIFY_VERSION": [GameMessageTypes.GAMEMESSAGE_VERIFY_VERSION],
		"GameMessageTypes.GAMEMESSAGE_VERSION_NACK": [GameMessageTypes.GAMEMESSAGE_VERSION_NACK],
		"GameMessageTypes.GAMEMESSAGE_VERSION_WARNING": [GameMessageTypes.GAMEMESSAGE_VERSION_WARNING],
		"GameMessageTypes.GAMEMESSAGE_GAME_TYPE": [GameMessageTypes.GAMEMESSAGE_GAME_TYPE],
		"GameMessageTypes.GAMEMESSAGE_ID_ASSIGNMENT": [GameMessageTypes.GAMEMESSAGE_ID_ASSIGNMENT],
		"GameMessageTypes.GAMEMESSAGE_FILE_INFO": [GameMessageTypes.GAMEMESSAGE_FILE_INFO],
		"GameMessageTypes.GAMEMESSAGE_PICK_YOUR_CIV": [GameMessageTypes.GAMEMESSAGE_PICK_YOUR_CIV],
		"GameMessageTypes.GAMEMESSAGE_CIV_CHOICE": [GameMessageTypes.GAMEMESSAGE_CIV_CHOICE],
		"GameMessageTypes.GAMEMESSAGE_CONFIRM_CIV_CLAIM": [GameMessageTypes.GAMEMESSAGE_CONFIRM_CIV_CLAIM],
		"GameMessageTypes.GAMEMESSAGE_CLAIM_INFO": [GameMessageTypes.GAMEMESSAGE_CLAIM_INFO],
		"GameMessageTypes.GAMEMESSAGE_CIV_CHOICE_ACK": [GameMessageTypes.GAMEMESSAGE_CIV_CHOICE_ACK],
		"GameMessageTypes.GAMEMESSAGE_CIV_CHOICE_NACK": [GameMessageTypes.GAMEMESSAGE_CIV_CHOICE_NACK],
		"GameMessageTypes.GAMEMESSAGE_CIV_CHOSEN": [GameMessageTypes.GAMEMESSAGE_CIV_CHOSEN],
		"GameMessageTypes.GAMEMESSAGE_INTERIM_NOTICE": [GameMessageTypes.GAMEMESSAGE_INTERIM_NOTICE],
		"GameMessageTypes.GAMEMESSAGE_INIT_INFO": [GameMessageTypes.GAMEMESSAGE_INIT_INFO],
		"GameMessageTypes.GAMEMESSAGE_MAPSCRIPT_CHECK": [GameMessageTypes.GAMEMESSAGE_MAPSCRIPT_CHECK],
		"GameMessageTypes.GAMEMESSAGE_MAPSCRIPT_ACK": [GameMessageTypes.GAMEMESSAGE_MAPSCRIPT_ACK],
		"GameMessageTypes.GAMEMESSAGE_LOAD_GAME": [GameMessageTypes.GAMEMESSAGE_LOAD_GAME],
		"GameMessageTypes.GAMEMESSAGE_PLAYER_ID": [GameMessageTypes.GAMEMESSAGE_PLAYER_ID],
		"GameMessageTypes.GAMEMESSAGE_SLOT_REASSIGNMENT": [GameMessageTypes.GAMEMESSAGE_SLOT_REASSIGNMENT],
		"GameMessageTypes.GAMEMESSAGE_PLAYER_INFO": [GameMessageTypes.GAMEMESSAGE_PLAYER_INFO],
		"GameMessageTypes.GAMEMESSAGE_GAME_INFO": [GameMessageTypes.GAMEMESSAGE_GAME_INFO],
		"GameMessageTypes.GAMEMESSAGE_REASSIGN_PLAYER": [GameMessageTypes.GAMEMESSAGE_REASSIGN_PLAYER],
		"GameMessageTypes.GAMEMESSAGE_PITBOSS_INFO": [GameMessageTypes.GAMEMESSAGE_PITBOSS_INFO],
		"GameMessageTypes.GAMEMESSAGE_LAUNCHING_INFO": [GameMessageTypes.GAMEMESSAGE_LAUNCHING_INFO],
		"GameMessageTypes.GAMEMESSAGE_INIT_GAME": [GameMessageTypes.GAMEMESSAGE_INIT_GAME],
		"GameMessageTypes.GAMEMESSAGE_INIT_PLAYERS": [GameMessageTypes.GAMEMESSAGE_INIT_PLAYERS],
		"GameMessageTypes.GAMEMESSAGE_AUTH_REQUEST": [GameMessageTypes.GAMEMESSAGE_AUTH_REQUEST],
		"GameMessageTypes.GAMEMESSAGE_AUTH_RESPONSE": [GameMessageTypes.GAMEMESSAGE_AUTH_RESPONSE],
		"GameMessageTypes.GAMEMESSAGE_SYNCH_START": [GameMessageTypes.GAMEMESSAGE_SYNCH_START],
		"GameMessageTypes.GAMEMESSAGE_PLAYER_OPTION": [GameMessageTypes.GAMEMESSAGE_PLAYER_OPTION],
		"GameMessageTypes.GAMEMESSAGE_EXTENDED_GAME": [GameMessageTypes.GAMEMESSAGE_EXTENDED_GAME],
		"GameMessageTypes.GAMEMESSAGE_AUTO_MOVES": [GameMessageTypes.GAMEMESSAGE_AUTO_MOVES],
		"GameMessageTypes.GAMEMESSAGE_TURN_COMPLETE": [GameMessageTypes.GAMEMESSAGE_TURN_COMPLETE],
		"GameMessageTypes.GAMEMESSAGE_JOIN_GROUP": [GameMessageTypes.GAMEMESSAGE_JOIN_GROUP],
		"GameMessageTypes.GAMEMESSAGE_PUSH_MISSION": [GameMessageTypes.GAMEMESSAGE_PUSH_MISSION],
		"GameMessageTypes.GAMEMESSAGE_AUTO_MISSION": [GameMessageTypes.GAMEMESSAGE_AUTO_MISSION],
		"GameMessageTypes.GAMEMESSAGE_DO_COMMAND": [GameMessageTypes.GAMEMESSAGE_DO_COMMAND],
		"GameMessageTypes.GAMEMESSAGE_PUSH_ORDER": [GameMessageTypes.GAMEMESSAGE_PUSH_ORDER],
		"GameMessageTypes.GAMEMESSAGE_POP_ORDER": [GameMessageTypes.GAMEMESSAGE_POP_ORDER],
		"GameMessageTypes.GAMEMESSAGE_DO_TASK": [GameMessageTypes.GAMEMESSAGE_DO_TASK],
		"GameMessageTypes.GAMEMESSAGE_RESEARCH": [GameMessageTypes.GAMEMESSAGE_RESEARCH],
		"GameMessageTypes.GAMEMESSAGE_PERCENT_CHANGE": [GameMessageTypes.GAMEMESSAGE_PERCENT_CHANGE],
		"GameMessageTypes.GAMEMESSAGE_ESPIONAGE_CHANGE": [GameMessageTypes.GAMEMESSAGE_ESPIONAGE_CHANGE],
		"GameMessageTypes.GAMEMESSAGE_CONVERT": [GameMessageTypes.GAMEMESSAGE_CONVERT],
		"GameMessageTypes.GAMEMESSAGE_CHAT": [GameMessageTypes.GAMEMESSAGE_CHAT],
		"GameMessageTypes.GAMEMESSAGE_PING": [GameMessageTypes.GAMEMESSAGE_PING],
		"GameMessageTypes.GAMEMESSAGE_SIGN": [GameMessageTypes.GAMEMESSAGE_SIGN],
		"GameMessageTypes.GAMEMESSAGE_LINE_ENTITY": [GameMessageTypes.GAMEMESSAGE_LINE_ENTITY],
		"GameMessageTypes.GAMEMESSAGE_SIGN_DELETE": [GameMessageTypes.GAMEMESSAGE_SIGN_DELETE],
		"GameMessageTypes.GAMEMESSAGE_LINE_ENTITY_DELETE": [GameMessageTypes.GAMEMESSAGE_LINE_ENTITY_DELETE],
		"GameMessageTypes.GAMEMESSAGE_LINE_GROUP_DELETE": [GameMessageTypes.GAMEMESSAGE_LINE_GROUP_DELETE],
		"GameMessageTypes.GAMEMESSAGE_PAUSE": [GameMessageTypes.GAMEMESSAGE_PAUSE],
		"GameMessageTypes.GAMEMESSAGE_MP_KICK": [GameMessageTypes.GAMEMESSAGE_MP_KICK],
		"GameMessageTypes.GAMEMESSAGE_MP_RETIRE": [GameMessageTypes.GAMEMESSAGE_MP_RETIRE],
		"GameMessageTypes.GAMEMESSAGE_CLOSE_CONNECTION": [GameMessageTypes.GAMEMESSAGE_CLOSE_CONNECTION],
		"GameMessageTypes.GAMEMESSAGE_NEVER_JOINED": [GameMessageTypes.GAMEMESSAGE_NEVER_JOINED],
		"GameMessageTypes.GAMEMESSAGE_MP_DROP_INIT": [GameMessageTypes.GAMEMESSAGE_MP_DROP_INIT],
		"GameMessageTypes.GAMEMESSAGE_MP_DROP_VOTE": [GameMessageTypes.GAMEMESSAGE_MP_DROP_VOTE],
		"GameMessageTypes.GAMEMESSAGE_MP_DROP_UPDATE": [GameMessageTypes.GAMEMESSAGE_MP_DROP_UPDATE],
		"GameMessageTypes.GAMEMESSAGE_MP_DROP_RESULT": [GameMessageTypes.GAMEMESSAGE_MP_DROP_RESULT],
		"GameMessageTypes.GAMEMESSAGE_MP_DROP_SAVE": [GameMessageTypes.GAMEMESSAGE_MP_DROP_SAVE],
		"GameMessageTypes.GAMEMESSAGE_TOGGLE_TRADE": [GameMessageTypes.GAMEMESSAGE_TOGGLE_TRADE],
		"GameMessageTypes.GAMEMESSAGE_IMPLEMENT_OFFER": [GameMessageTypes.GAMEMESSAGE_IMPLEMENT_OFFER],
		"GameMessageTypes.GAMEMESSAGE_CHANGE_WAR": [GameMessageTypes.GAMEMESSAGE_CHANGE_WAR],
		"GameMessageTypes.GAMEMESSAGE_CHANGE_VASSAL": [GameMessageTypes.GAMEMESSAGE_CHANGE_VASSAL],
		"GameMessageTypes.GAMEMESSAGE_CHOOSE_ELECTION": [GameMessageTypes.GAMEMESSAGE_CHOOSE_ELECTION],
		"GameMessageTypes.GAMEMESSAGE_DIPLO_VOTE": [GameMessageTypes.GAMEMESSAGE_DIPLO_VOTE],
		"GameMessageTypes.GAMEMESSAGE_APPLY_EVENT": [GameMessageTypes.GAMEMESSAGE_APPLY_EVENT],
		"GameMessageTypes.GAMEMESSAGE_CONTACT_CIV": [GameMessageTypes.GAMEMESSAGE_CONTACT_CIV],
		"GameMessageTypes.GAMEMESSAGE_DIPLO_CHAT": [GameMessageTypes.GAMEMESSAGE_DIPLO_CHAT],
		"GameMessageTypes.GAMEMESSAGE_SEND_OFFER": [GameMessageTypes.GAMEMESSAGE_SEND_OFFER],
		"GameMessageTypes.GAMEMESSAGE_DIPLO_EVENT": [GameMessageTypes.GAMEMESSAGE_DIPLO_EVENT],
		"GameMessageTypes.GAMEMESSAGE_RENEGOTIATE": [GameMessageTypes.GAMEMESSAGE_RENEGOTIATE],
		"GameMessageTypes.GAMEMESSAGE_RENEGOTIATE_ITEM": [GameMessageTypes.GAMEMESSAGE_RENEGOTIATE_ITEM],
		"GameMessageTypes.GAMEMESSAGE_EXIT_TRADE": [GameMessageTypes.GAMEMESSAGE_EXIT_TRADE],
		"GameMessageTypes.GAMEMESSAGE_KILL_DEAL": [GameMessageTypes.GAMEMESSAGE_KILL_DEAL],
		"GameMessageTypes.GAMEMESSAGE_SAVE_GAME": [GameMessageTypes.GAMEMESSAGE_SAVE_GAME],
		"GameMessageTypes.GAMEMESSAGE_UPDATE_CIVICS": [GameMessageTypes.GAMEMESSAGE_UPDATE_CIVICS],
		"GameMessageTypes.GAMEMESSAGE_CLEAR_TABLE": [GameMessageTypes.GAMEMESSAGE_CLEAR_TABLE],
		"GameMessageTypes.GAMEMESSAGE_POPUP_PROCESSED": [GameMessageTypes.GAMEMESSAGE_POPUP_PROCESSED],
		"GameMessageTypes.GAMEMESSAGE_DIPLOMACY_PROCESSED": [GameMessageTypes.GAMEMESSAGE_DIPLOMACY_PROCESSED],
		"GameMessageTypes.GAMEMESSAGE_HOT_JOIN_NOTICE": [GameMessageTypes.GAMEMESSAGE_HOT_JOIN_NOTICE],
		"GameMessageTypes.GAMEMESSAGE_HOT_DROP_NOTICE": [GameMessageTypes.GAMEMESSAGE_HOT_DROP_NOTICE],
		"GameMessageTypes.GAMEMESSAGE_DIPLOMACY": [GameMessageTypes.GAMEMESSAGE_DIPLOMACY],
		"GameMessageTypes.GAMEMESSAGE_POPUP": [GameMessageTypes.GAMEMESSAGE_POPUP],
		"GameMessageTypes.GAMEMESSAGE_EVENT_TRIGGERED": [GameMessageTypes.GAMEMESSAGE_EVENT_TRIGGERED],
		"GameMessageTypes.GAMEMESSAGE_EMPIRE_SPLIT": [GameMessageTypes.GAMEMESSAGE_EMPIRE_SPLIT],
		"GameMessageTypes.GAMEMESSAGE_LAUNCH_SPACESHIP": [GameMessageTypes.GAMEMESSAGE_LAUNCH_SPACESHIP],
		"GameMessageTypes.GAMEMESSAGE_ADVANCED_START_ACTION": [GameMessageTypes.GAMEMESSAGE_ADVANCED_START_ACTION],
		"GameMessageTypes.GAMEMESSAGE_FOUND_RELIGION": [GameMessageTypes.GAMEMESSAGE_FOUND_RELIGION],
		"GameMessageTypes.GAMEMESSAGE_MOD_NET_MESSAGE": [GameMessageTypes.GAMEMESSAGE_MOD_NET_MESSAGE],
		"PopupControlLayout.POPUP_LAYOUT_LEFT": [PopupControlLayout.POPUP_LAYOUT_LEFT],
		"PopupControlLayout.POPUP_LAYOUT_CENTER": [PopupControlLayout.POPUP_LAYOUT_CENTER],
		"PopupControlLayout.POPUP_LAYOUT_RIGHT": [PopupControlLayout.POPUP_LAYOUT_RIGHT],
		"PopupControlLayout.POPUP_LAYOUT_STRETCH": [PopupControlLayout.POPUP_LAYOUT_STRETCH],
		"PopupControlLayout.POPUP_LAYOUT_NUMLAYOUTS": [PopupControlLayout.POPUP_LAYOUT_NUMLAYOUTS],
		"JustificationTypes.DLL_FONT_LEFT_JUSTIFY": [JustificationTypes.DLL_FONT_LEFT_JUSTIFY],
		"JustificationTypes.DLL_FONT_RIGHT_JUSTIFY": [JustificationTypes.DLL_FONT_RIGHT_JUSTIFY],
		"JustificationTypes.DLL_FONT_CENTER_JUSTIFY": [JustificationTypes.DLL_FONT_CENTER_JUSTIFY],
		"JustificationTypes.DLL_FONT_CENTER_VERTICALLY": [JustificationTypes.DLL_FONT_CENTER_VERTICALLY],
		"JustificationTypes.DLL_FONT_ADDITIVE": [JustificationTypes.DLL_FONT_ADDITIVE],
		"ToolTipAlignTypes.TOOLTIP_TOP_LEFT": [ToolTipAlignTypes.TOOLTIP_TOP_LEFT],
		"ToolTipAlignTypes.TOOLTIP_TOP_INLEFT": [ToolTipAlignTypes.TOOLTIP_TOP_INLEFT],
		"ToolTipAlignTypes.TOOLTIP_TOP_CENTER": [ToolTipAlignTypes.TOOLTIP_TOP_CENTER],
		"ToolTipAlignTypes.TOOLTIP_TOP_INRIGHT": [ToolTipAlignTypes.TOOLTIP_TOP_INRIGHT],
		"ToolTipAlignTypes.TOOLTIP_TOP_RIGHT": [ToolTipAlignTypes.TOOLTIP_TOP_RIGHT],
		"ToolTipAlignTypes.TOOLTIP_INTOP_RIGHT": [ToolTipAlignTypes.TOOLTIP_INTOP_RIGHT],
		"ToolTipAlignTypes.TOOLTIP_CENTER_RIGHT": [ToolTipAlignTypes.TOOLTIP_CENTER_RIGHT],
		"ToolTipAlignTypes.TOOLTIP_INBOTTOM_RIGHT": [ToolTipAlignTypes.TOOLTIP_INBOTTOM_RIGHT],
		"ToolTipAlignTypes.TOOLTIP_BOTTOM_RIGHT": [ToolTipAlignTypes.TOOLTIP_BOTTOM_RIGHT],
		"ToolTipAlignTypes.TOOLTIP_BOTTOM_INRIGHT": [ToolTipAlignTypes.TOOLTIP_BOTTOM_INRIGHT],
		"ToolTipAlignTypes.TOOLTIP_BOTTOM_CENTER": [ToolTipAlignTypes.TOOLTIP_BOTTOM_CENTER],
		"ToolTipAlignTypes.TOOLTIP_BOTTOM_INLEFT": [ToolTipAlignTypes.TOOLTIP_BOTTOM_INLEFT],
		"ToolTipAlignTypes.TOOLTIP_BOTTOM_LEFT": [ToolTipAlignTypes.TOOLTIP_BOTTOM_LEFT],
		"ToolTipAlignTypes.TOOLTIP_INBOTTOM_LEFT": [ToolTipAlignTypes.TOOLTIP_INBOTTOM_LEFT],
		"ToolTipAlignTypes.TOOLTIP_CENTER_LEFT": [ToolTipAlignTypes.TOOLTIP_CENTER_LEFT],
		"ToolTipAlignTypes.TOOLTIP_INTOP_LEFT": [ToolTipAlignTypes.TOOLTIP_INTOP_LEFT],
		"ActivationTypes.ACTIVATE_NORMAL": [ActivationTypes.ACTIVATE_NORMAL],
		"ActivationTypes.ACTIVATE_CHILDFOCUS": [ActivationTypes.ACTIVATE_CHILDFOCUS],
		"ActivationTypes.ACTIVATE_MIMICPARENT": [ActivationTypes.ACTIVATE_MIMICPARENT],
		"ActivationTypes.ACTIVATE_MIMICPARENTFOCUS": [ActivationTypes.ACTIVATE_MIMICPARENTFOCUS],
		"HitTestTypes.HITTEST_DEFAULT": [HitTestTypes.HITTEST_DEFAULT],
		"HitTestTypes.HITTEST_NOHIT": [HitTestTypes.HITTEST_NOHIT],
		"HitTestTypes.HITTEST_SOLID": [HitTestTypes.HITTEST_SOLID],
		"HitTestTypes.HITTEST_ON": [HitTestTypes.HITTEST_ON],
		"HitTestTypes.HITTEST_CHILDREN": [HitTestTypes.HITTEST_CHILDREN],
		"GraphicLevelTypes.GRAPHICLEVEL_HIGH": [GraphicLevelTypes.GRAPHICLEVEL_HIGH],
		"GraphicLevelTypes.GRAPHICLEVEL_MEDIUM": [GraphicLevelTypes.GRAPHICLEVEL_MEDIUM],
		"GraphicLevelTypes.GRAPHICLEVEL_LOW": [GraphicLevelTypes.GRAPHICLEVEL_LOW],
		"GraphicLevelTypes.GRAPHICLEVEL_CURRENT": [GraphicLevelTypes.GRAPHICLEVEL_CURRENT],
		"GraphicLevelTypes.NUM_GRAPHICLEVELS": [GraphicLevelTypes.NUM_GRAPHICLEVELS],
		"EventTypes.NO_EVENT": [EventTypes.NO_EVENT],
		"EventTriggerTypes.NO_EVENTTRIGGER": [EventTriggerTypes.NO_EVENTTRIGGER],
		"EspionageMissionTypes.NO_ESPIONAGEMISSION": [EspionageMissionTypes.NO_ESPIONAGEMISSION],
		"AdvancedStartActionTypes.NO_ADVANCEDSTARTACTION": [AdvancedStartActionTypes.NO_ADVANCEDSTARTACTION],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_EXIT": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_EXIT],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_UNIT": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_UNIT],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_CITY": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_CITY],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_POP": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_POP],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_CULTURE": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_CULTURE],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_BUILDING": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_BUILDING],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_IMPROVEMENT": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_IMPROVEMENT],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_ROUTE": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_ROUTE],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_TECH": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_TECH],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_VISIBILITY": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_VISIBILITY],
		"AdvancedStartActionTypes.ADVANCEDSTARTACTION_AUTOMATE": [AdvancedStartActionTypes.ADVANCEDSTARTACTION_AUTOMATE],
		"NotifyCode.NOTIFY_CHARACTER": [NotifyCode.NOTIFY_CHARACTER],
		"NotifyCode.NOTIFY_CLICKED": [NotifyCode.NOTIFY_CLICKED],
		"NotifyCode.NOTIFY_CURSOR_MOVE_OFF": [NotifyCode.NOTIFY_CURSOR_MOVE_OFF],
		"NotifyCode.NOTIFY_CURSOR_MOVE_ON": [NotifyCode.NOTIFY_CURSOR_MOVE_ON],
		"NotifyCode.NOTIFY_LISTBOX_ITEM_SELECTED": [NotifyCode.NOTIFY_LISTBOX_ITEM_SELECTED],
		"NotifyCode.NOTIFY_MOVIE_DONE": [NotifyCode.NOTIFY_MOVIE_DONE],
		"NotifyCode.NOTIFY_SLIDER_NEWSTOP": [NotifyCode.NOTIFY_SLIDER_NEWSTOP],
		"MouseFlags.MOUSE_LBUTTONUP": [MouseFlags.MOUSE_LBUTTONUP],
		"MouseFlags.MOUSE_RBUTTONUP": [MouseFlags.MOUSE_RBUTTONUP],
		# "InputTypes.KB_NONE": [InputTypes.KB_NONE],
		# "ButtonPopupTypes.BUTTONPOPUP_CONFIRM_MENU_KI": [ButtonPopupTypes.BUTTONPOPUP_CONFIRM_MENU_KI],
		# "DomainTypes.DOMAIN_HELICOPTER": [DomainTypes.DOMAIN_HELICOPTER],
		# "EntityEventTypes.ENTEVENT_MOVE": [EntityEventTypes.ENTEVENT_MOVE],
		# "CivilopediaPageTypes.CIVILOPEDIA_PAGE_MAIN": [CivilopediaPageTypes.CIVILOPEDIA_PAGE_MAIN],
		# "AnimationPathTypes.ANIMATIONPATH_RUN": [AnimationPathTypes.ANIMATIONPATH_RUN],
}


def replace_key_functions(fsource, ftarget):
		f = file(fsource, 'rU')  # noqa
		f2 = file(ftarget, 'w')  # noqa
		l = f.readline()
		while(l):
				# Ignore Lines without identation"
				if l[0] == "\t" or l[:2] == "  ":
						l2 = replaceLoop(l)
				else:
						l2 = l

				f2.write(l2)
				l = f.readline()

		f2.close()
		f.close()


def replaceLoop(codeline):
		out = codeline

		# check if single comment line
		if len(out[:out.find("#")].strip()) == 0:
				return out

		for fname in Constant_substitutions:
				tConst = Constant_substitutions[fname]
				out = out.replace(tConst[0], str(tConst[1]))

		"""
		for tname in Type_substitutions:
				tpos = 0  # Start index for multiple substitution candidates
				while tname in out[tpos:]:
						tpos = out.find(tname, tpos) + len(tname)  # AFTER match
						if out[tpos:tpos+1] not in Type_varname_splitter:
								# Hey, tname is a real substring of the type name, i.e.
								# 'FooTypes.A' in 'FooTypes.ABC_DE'
								continue

						sType = str(int(Type_substitutions[tname][0]))
						# import pdb; pdb.set_trace()
						out = out[:tpos-len(tname)] + sType + out[tpos:]
						tpos += (len(sType) - len(tname))  # Shrink
		"""

		for fname in Replace_descriptors:
				if fname not in out:  # Skip most regex engine calls
						continue

				tDesc = Replace_descriptors[fname]  # Tuple
				matches = list(re.finditer(tDesc[0], out))
				if len(matches) == 0:
						continue

				out2 = ""
				prev_end = 0
				for m in matches:
						out2 += out[prev_end:m.start()]
						# Parse arg (currenty only one arg supported)
						arg1 = tDesc[2] % (m.group(tDesc[1]),)
						# Evaluate expression
						out2 += str(undefined_warner(tDesc[3], arg1))
						prev_end = m.end()

				out2 += out[prev_end:]
				out = out2

		return out


def main(forceUpdate=False, basedir=PyModPath, outdir=PyOutPath):

		# List of files, which already exists.
		target_files = glob.glob(outdir+"/*.py") +\
				glob.glob(outdir+"/*/*.py") + glob.glob(outdir+"/*/*/*.py")

		# Collection of files which should be parsed.
		# ("source path", timestamp_source, "target_path", timestamp_target)
		files = []

		# Map source file path to target file path and add timestamp.
		# This allows filtering of unchanged files
		# and filtering of double file (files with same target)
		# Note that basedir will vary.
		def addTargetTs(basedir, targets, s):
				t = s.replace(basedir, outdir, 1)
				if t in target_files:
						return (t, os.path.getctime(t))
				else:
						return (t, None)

		for basedir in SourceFolders:
				source_files = glob.glob(basedir+"/*.py") +\
						glob.glob(basedir+"/*/*.py") +\
						glob.glob(basedir+"/*/*/*.py")

				files.extend(
						[(x, os.path.getctime(x)) + addTargetTs(basedir, target_files, x)
						 for x in source_files]
				)

		# Note that above list contain duplicates because some files exists at
		# multiple source folders. The duplicates had the same target paths.
		# We will just hold the latest instance.
		tmp = [(x[2], x) for x in files]
		files = dict(tmp).values()

		# Sort by timestamp, optional
		# files.sort(key=lambda xx: xx[1])
		# files = [files[10]]

		# Ignore this file due parsing
		this_file_name = __name__ + ".py"

		for tF in files:
				# Check if target file is newer as source file
				if(tF[3] is not None and tF[3] > tF[1] and not forceUpdate):
						print("Skip", tF[0])
						continue

				s = tF[0]
				t = tF[2]
				targetDir = t[:t.rfind(os.path.sep)]
				fname = t[t.rfind(os.path.sep)+1:]

				if fname == this_file_name:
						continue

				if not os.path.isdir(targetDir):
						os.makedirs(targetDir)

				print("Update '%s' -> '%s'" % (s, t))
				replace_key_functions(s, t)


if __name__ == "__main__":
		try:
				bForce = bool(int(sys.argv[1]))
		except:
				bForce = False

		main(bForce)
